
;coded by UEZ build 2016-01-24
#pragma compile(Icon, "c:\Program Files (x86)\AutoIt3\Icons\au3.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>


_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $iShowFPS = 0, $bExit
Global Const $iW = 800, $iH = 500, $sTitle = "GDI+ Smoke FX v1.1"
AutoItSetOption("GUIOnEventMode", 1)

_Init_GDIPlusEx()
GDIPlus_Smoke()

_GDIPlus_Shutdown()


Func GDIPlus_Smoke()
	$bExit = False
	$hGUI = GUICreate($sTitle, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)
;~ 	GUISetCursor(16, 1)

	;create canvas elements
	Local $oBuffer = _GDIPlusEx_BufferCreate($hGUI)
;~ 	_GDIPlus_GraphicsSetSmoothingMode($oBuffer.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBuffer.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hBrush_FPS = _GDIPlus_BrushCreateSolid(0xF0808080), _
				$hFormat_FPS = _GDIPlus_StringFormatCreate(), _
				$hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), _
				$hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), _
				$tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 60, 16)

	Local $i, $iSmoke = 110, $aBmpCoords[$iSmoke][11], $iW2 = $iW / 2, $c = Random(-2^30, 2^16)
	Local $aBmps[4] = [	_GDIPlusEx_BitmapCreateFromMemory(_Smoke1()), _GDIPlusEx_BitmapCreateFromMemory(_Smoke2()), _
						_GDIPlusEx_BitmapCreateFromMemory(_Smoke3()), _GDIPlusEx_BitmapCreateFromMemory(_Smoke4())]

	For $i = 0 To UBound($aBmpCoords) - 1
		$aBmpCoords[$i][1] = $iH - Random(0, 100)
		$aBmpCoords[$i][2] = Random(-2, 0.5)
		$aBmpCoords[$i][3] = Random(-5.5, -2.5)
		$aBmpCoords[$i][4] = Random(0, UBound($aBmps) - 1, 1)
		$aBmpCoords[$i][5] = 0.05
		$aBmpCoords[$i][10] = 0.05
		$aBmpCoords[$i][6] = _GDIPlus_ImageGetWidth($aBmps[$aBmpCoords[$i][4]].Bmp)
		$aBmpCoords[$i][7] = _GDIPlus_ImageGetHeight($aBmps[$aBmpCoords[$i][4]].Bmp)
		$aBmpCoords[$i][8] = Random(0.25, 1)
		$aBmpCoords[$i][9] = Random(0.01, 0.075)
		$aBmpCoords[$i][0] = $iW2 + ($aBmpCoords[$i][6] * $aBmpCoords[$i][5]) / 2
	Next

	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	$iFPS = 0
	AdlibRegister("CalcFPS", 1000)

	Do
		_GDIPlus_GraphicsClear($oBuffer.Gfx, 0xFFF8F8FF)

		For $i = 0 To UBound($aBmpCoords) - 1
			_GDIPlusEx_BitmapDrawRectRect($oBuffer, $aBmps[$aBmpCoords[$i][4]], 0, 0, $aBmpCoords[$i][6], $aBmpCoords[$i][7], _
										  $aBmpCoords[$i][0] - ($aBmpCoords[$i][6] * $aBmpCoords[$i][5]) / 2, $aBmpCoords[$i][1], _
										  $aBmpCoords[$i][6] * $aBmpCoords[$i][5], $aBmpCoords[$i][7] * $aBmpCoords[$i][10], $aBmpCoords[$i][8])
			$aBmpCoords[$i][5] += 0.0075
			$aBmpCoords[$i][10] += 0.0075
			$aBmpCoords[$i][0] += $aBmpCoords[$i][2] + ATan(10 * Cos($c / 500) * $aBmpCoords[$i][5] * $aBmpCoords[$i][10]) * 5.25 ;wind simulation
			$aBmpCoords[$i][1] += $aBmpCoords[$i][3] + Sin($c / 50) * 2.5
			$aBmpCoords[$i][8] -= $aBmpCoords[$i][9]
			If $aBmpCoords[$i][8] < 0 Then
				$aBmpCoords[$i][1] = $iH
				$aBmpCoords[$i][2] = Random(-3, 1)
				$aBmpCoords[$i][3] = Random(-6.5, -2.5)
				$aBmpCoords[$i][4] = Random(0, UBound($aBmps) - 1, 1)
				$aBmpCoords[$i][5] = Random(0.02, 0.075)
				$aBmpCoords[$i][10] = Random(0.02, 0.075)
				$aBmpCoords[$i][6] = DllCall($__g_hGDIPDll, "int", "GdipGetImageWidth", "handle", $aBmps[$aBmpCoords[$i][4]].Bmp, "uint*", 0)[2]
				$aBmpCoords[$i][7] = DllCall($__g_hGDIPDll, "int", "GdipGetImageHeight", "handle", $aBmps[$aBmpCoords[$i][4]].Bmp, "uint*", 0)[2]
				$aBmpCoords[$i][8] = Random(0.8, 1)
				$aBmpCoords[$i][9] = Random(0.01, 0.05)
				$aBmpCoords[$i][0] = $iW2 + ($aBmpCoords[$i][6] * $aBmpCoords[$i][5]) / 2
			EndIf
			$c += 0.01
		Next

		_GDIPlus_GraphicsDrawStringEx($oBuffer.Gfx, "FPS: " & $iShowFPS, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS) ;draw background message text

		_GDIPlusEx_BufferDraw($oBuffer)

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	For $i = 0 To UBound($aBmps) - 1
		$aBmps[$i] = Null
	Next
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_BrushDispose($hBrush_FPS)
	$oBuffer = Null
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Smoke

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS
	$iFPS = 0
EndFunc   ;==>CalcFPS


Func _Init_GDIPlusEx()
	Global Const $_cGDIPEX_ISBMP = 0x41455047
	Global Const $_cGDIPEX_ISBUF = 0x42455047
	Global Const $_sGDIPEX_IIDBMP = "{EB22CE37-EE56-458B-AD13-3FC836E8CE49}"
	Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
	Global Const $_tagGDIPEX_BUFFER = "Draw int(int;int;uint); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
	Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
	Global $_aGDIPEX_ASMSTRUCT[1]
	OnAutoItExitRegister("__GDIPlusEx_OnExit")
	Global Const $_hGDIPEX_GDIPDLL = _GDIPlus_Startup()
	Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
	Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
	Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
	Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
	Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
	Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
	Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
	Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
	Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
	Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
	Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
	Global Const $_pGDIPEX_LIB_BMPDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDisposeImage")
	Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
	Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBMP = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B0400752A8B432C8B532052FFD08B43308B532452FFD08B43288B531C52FFD08B432853FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075314883EC20488B4348488B4B30FFD0488B4350488B4B38FFD0488B4340488B4B28FFD0488B43404889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x5356578B5C24108B7424148B7C2418B8FFFFFFFF817B0847504542752E8B4C241C5183EC08C7042400000000C7442404000000008B5328528B5310528B530C5257568B5324528B434CFFD05F5E5BC21000", "0x534889CB4989D24D89C348C7C0FFFFFFFF81790C47504542754B4883EC484C894C244048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B104D89D84C89D2488B4B38488B8388000000FFD04883C4485BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPBMP = __GDIPlusEx_ASMCreate("0x8B5424048B4224C20400", "0x488B4138C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPGFX = __GDIPlusEx_ASMCreate("0x8B5424048B4220C20400", "0x488B4130C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPSCAN0 = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_BMPDRAW = __GDIPlusEx_ASMCreate("0x5756538B7424108B7C2414817F0847504542740E817F08475045417405E98E010000F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C289542410B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED8B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C248A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C60483C70483E9010F8F63FFFFFF83EB010F8F3FFFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554883EC20F30F7F3424F30F7F7C24104889CE4889D7817F0C47504542740E817F0C475045417405E99D010000F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFFF660F6FF0F30F7E6F10660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F4B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED4489CB4C89D74D01DA4C89E64D01EC4489C18A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C6044883C70483E9010F8F61FFFFFF83EB010F8F49FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF30F6F7C2410F30F6F34244883C420415D415C5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPDRAWRECT = __GDIPlusEx_ASMCreate("0x575653558B7424148B7C2418817F0847504542740E817F08475045417405E9DA010000F30F6F44241CF30F7E560CF30F7E5F0C0F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F858C0100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD283EC20660FD60424660FD64C2408660F7ED1660F73DA04660F7ED38B4714894424140FAFC38D04888B571889D501C2895424108B4424140FAF471001C58B46148944241C8B761889742418B800000047660F6EF8660F70FF00B801000000F30F2AF08B0C24F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1013B4C24087CE0660F70EDE18B5C24048B7C24108B44241401442410F30F2AC3F30F59C5F30F2CC08B7424180FAF44241C01C68B0C248B548D008A4416033C000F8488000000660F6E04163CFF747B660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10D0F30F58D1F30F53E2660F70D9000F59CB660F70D8000F59C3660F70E4000F58C10F59C4F30F10C20F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C70483C1013B4C24080F8C58FFFFFF83C3013B5C240C0F8C25FFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5D5B5E5FC21800", "0x660F6E4C2428660F6E442430660F62C85756535541544155415641574883EC30F30F7F3424F30F7F7C2410F3440F7F4424204889D74889CE817F0C47504542740E817F0C475045417405E9FA01000066410F6EC066410F6ED1660F73FA04660FEBC2660F73F908660FEBC1F30F7E5610F30F7E5F100F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F85940100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD266490F7EC04D89C149C1E92066490F7ECA4D89D349C1EB20660F7ED1660F73DA04660F7ED34831C08B47184989C50FAFC3678D04884C8B67204C89E54901C44C89E80FAF47144801C58B46184989C74C8B7620B800000047660F6EF8660F70FF00B801000000F30F2AF04831C94489C1F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1014439D17CE14831D2660F70EDE14489CB4C89E74D01ECF30F2AC3F30F59C5F3480F2CC04C89F6410FAFC74801C64489C18B548D008A4416033C000F848C000000660F6E04163CFF747F660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF3440F10C0F3440F58C1F3410F53E0660F70D900660F70D0000F59CB0F59C2660F70E4000F58C10F59C4F3410F10C00F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C70483C1014439D10F8C54FFFFFF83C3014439DB0F8C28FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF3440F6F442420F30F6F7C2410F30F6F34244883C430415F415E415D415C5D5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPCLR = __GDIPlusEx_ASMCreate("0x8B542404660F6E442408660F70C0008B4A100FAF4A148B5218660F7F0283C21083E9107FF4C20800", "0x660F6EC2660F70C0008B51140FAF5118488B4920660F7F014883C11083EA107FF3C3")
	Global Const $_pGDIPEX_ASM_BMPCLONE = __GDIPlusEx_ASMCreate("0x5756538B7C24108B7424148B7614F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F858F00000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C2895424108B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C24F30F6F06F30F7F0783C61083C71083E9047FED83EB017FCD83C420B800000000EB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554889CF4889D6488B7628F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFED660F6FE0F30F7E5F10660FEACB660FEEC5660FFAC8660F6FD0660FFAD4B801000000660F6EE8660F70EDE0660F66E9660FD7C583F8000F858F00000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F44489CB4C89D74D01DA4C89E64D01EC4489C1F30F6F06F30F7F074883C6104883C71083E9047FEB83EB017FD748C7C000000000EB0748C7C0FFFFFFFF415D415C5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPTRANS = __GDIPlusEx_ASMCreate("0x578B7C2408660F6E7C240C660F70FF00B800000047660F6EF0660F70F600B8FFFFFF00660F6EE8660F70ED008B4F100FAF4F148B7F18660F6F07660F6FC8660FDBC5660F72D118660FFECE0F5CCE0F59CF0F58CE660FFACE660F72F118660FEBC1660F7F0783C71083E9107FC95FC20800", "0x660F70E900B800000047660F6EE0660F70E400B8FFFFFF00660F6ED8660F70DB008B41140FAF4118488B4920660F6F01660F6FC8660FDBC3660F72D118660FFECC0F5CCC0F59CD0F58CC660FFACC660F72F118660FEBC1660F7F014883C11083E8107FC8C3")
	Global Const $_pGDIPEX_ASM_FXBLUR = __GDIPlusEx_ASMCreate("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
			"0x5356574154415541564157554883EC50F30F7F3424F30F7F7C2410F3440F7F442420F3440F7F4C2430F3440F7F5424404D31C94D31DB448B4910448B5114448B59184C8B71204C8B7A20B800000047660F6EF8660F70FF00B801000000F3440F2AC066450F70C0004D89FD4D89F44489D34C89E74C89EE4983C4044D01DD4C89D248C1E202660FEFF6660FEFED660FEFE4450F57C9450F57D248C7C0000000004489C1660F6E0406660F60C4660FFDF0660F6FC6660F61C4660FFEE8450F58D0450F58CA4883C00483E9017FD64489C1410F53D9660F6FC5660FFEC70F5CC70F59C30F58C7660FFAC7660F6BC0660F67C0660F7E07660F6E0406660F6E0E660F60C4660F60CC0F16C1660FFDF0660FF9F1660F6FCE660F6FC6660F69CC660F61C4660FFAE9660FFEE8450F5CD0450F58CA4883C6044801D783E9017F93410F53D94889C548F7DD4489C94429C14429C1660F6FC5660FFEC70F5CC70F59C30F58C7660FFAC7660F6BC0660F67C0660F7E07660F6E0406660F6E0E660F6E142E660F60C4660F60CC660F60D40F16C10F16CA660FFDF0660FF9F1660F6FCE660F6FC6660F69CC660F61C4660FFAE9660FFEE84883C6044801D783E9017F93450F57D24489C1410F53D9660F6FC5660FFEC70F5CC70F59C30F58C7660FFAC7660F6BC0660F67C0660F7E07660F6E06660F6E0C2E660F60C4660F60CC0F16C1660FF9F0660F73F808660FFDF0660F6FCE660F6FC6660F69CC660F61C4660FFAE9660FFEE8450F58D0450F5CCA4883C6044801D783E9017F8E83EB010F8F32FEFFFF4D89F54D89FC4489CB4C89E74C89EE4C89D248C1E2024983C4044901D54C89DA660FEFF6660FEFED660FEFE4450F57C9450F57D248C7C0000000004489C1660F6E0406660F60C4660FFDF0660F6FC6660F61C4660FFEE8450F58D0450F58CA4883C00483E9017FD64489C1410F53D9660F6FC5660FFEC70F5CC70F59C30F58C7660FFAC7660F6BC0660F67C0660F7E07660F6E0406660F6E0E660F60C4660F60CC0F16C1660FFDF0660FF9F1660F6FCE660F6FC6660F69CC660F61C4660FFAE9660FFEE8450F5CD0450F58CA4883C6044801D783E9017F93410F53D94889C548F7DD4489D14429C14429C1660F6FC5660FFEC70F5CC70F59C30F58C7660FFAC7660F6BC0660F67C0660F7E07660F6E0406660F6E0E660F6E142E660F60C4660F60CC660F60D40F16C10F16CA660FFDF0660FF9F1660F6FCE660F6FC6660F69CC660F61C4660FFAE9660FFEE84883C6044801D783E9017F93450F57D24489C1410F53D9660F6FC5660FFEC70F5CC70F59C30F58C7660FFAC7660F6BC0660F67C0660F7E07660F6E06660F6E0C2E660F60C4660F60CC0F16C1660FF9F0660F73F808660FFDF0660F6FCE660F6FC6660F69CC660F61C4660FFAE9660FFEE8450F58D0450F5CCA4883C6044801D783E9017F8E83EB010F8F2FFEFFFFF3440F6F542440F3440F6F4C2430F3440F6F442420F30F6F7C2410F30F6F34244883C4505D415F415E415D415C5F5E5BC3")

EndFunc   ;==>_Init_GDIPlusEx

Func _GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBmp = __GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRABORTED, 2, False)
	Local $oBitmap = __GDIPlusEx_BitmapCreateObject($tBmp)
	If Not IsObj($oBitmap) Then
		__GDIPlusEx_BitmapDispose($tBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreate

Func _GDIPlusEx_BitmapCreateFromMemory($bImage, $iWidth = 0, $iHeight = 0, $hImgAttr = 0, $iInterpolationMode = 6)
	Local $hImage = _GDIPlus_BitmapCreateFromMemory($bImage)
	If @error Or Not $hImage Then Return SetError(@error, @extended, False)

	Local $tBitmap = _GDIPlusEx_BitmapCreateFromImage($hImage, $iWidth, $iHeight, $hImgAttr, $iInterpolationMode)
	Local $iError = @error, $iExtended = @extended

	_GDIPlus_ImageDispose($hImage)

	Return SetError($iError, $iExtended, $tBitmap)
EndFunc   ;==>_GDIPlusEx_BitmapCreateFromMemory

Func _GDIPlusEx_BitmapCreateFromImage($hImage, $iWidth = 0, $iHeight = 0, $hImgAttr = 0, $iInterpolationMode = 6)
	Local $iImgW = _GDIPlus_ImageGetWidth($hImage)
	Local $iImgH = _GDIPlus_ImageGetHeight($hImage)
	If @error Or Not $iImgW Or Not $iImgH Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)

	If $iWidth = 0 Then $iWidth = $iImgW
	If $iHeight = 0 Then $iHeight = $iImgH

	Local $oBitmap = _GDIPlusEx_BitmapCreate($iWidth, $iHeight)
	If @error Then Return SetError(@error, @extended, False)

	Local $iIP = _GDIPlus_GraphicsGetInterpolationMode($oBitmap.Gfx)
	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iInterpolationMode)

	_GDIPlus_GraphicsDrawImageRectRect($oBitmap.Gfx, $hImage, 0, 0, $iImgW, $iImgH, 0, 0, $iWidth, $iHeight, $hImgAttr)

	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iIP)
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreateFromImage

Func _GDIPlusEx_BitmapDraw($oBuffer, $oBitmap, $iX = 0, $iY = 0)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 2, False)
	Local $iStatus = $oBitmap.Draw($oBuffer, $iX, $iY)
	If $iStatus Then Return SetError($GDIP_ERRABORTED, 3, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapDraw

Func _GDIPlusEx_BitmapDrawRectRect($oBuffer, $oBitmap, $iSrcX, $iSrcY, $iSrcW, $iSrcH, $iDstX = 0, $iDstY = 0, $iDstW = 0, $iDstH = 0, $fTrans = 1)
	If $fTrans = 0 Then Return True ;No Error, but nothing to draw...
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 2, False)

	If $iDstW = 0 Then $iDstW = $iSrcW
	If $iDstH = 0 Then $iDstH = $iSrcH

	Local $tClone = __GDIPlusEx_BitmapClone($oBitmap, $iSrcX, $iSrcY, $iSrcW, $iSrcH)
	If @error Or Not IsDllStruct($tClone) Then Return SetError($GDIP_ERRABORTED, 3, False)

	If $fTrans <> 1 Then DllCallAddress("none", $_pGDIPEX_ASM_BMPTRANS, "struct*", $tClone, "float", $fTrans)

	If $iSrcW = $iDstW And $iSrcH = $iDstH Then
		DllCallAddress("int", $_pGDIPEX_ASM_BMPDRAW, "struct*", $tClone, "struct*", __GDIPlusEx_ObjGetPtr($oBuffer), "int", $iDstX, "int", $iDstY)
	Else
		DllCallAddress("int", $_pGDIPEX_ASM_BMPDRAWRECT, "struct*", $tClone, "struct*", __GDIPlusEx_ObjGetPtr($oBuffer), "int", $iDstX, "int", $iDstY, "uint", $iDstW, "uint", $iDstH)
	EndIf

	__GDIPlusEx_BitmapDispose($tClone)

	Return True
EndFunc   ;==>_GDIPlusEx_BitmapDrawRectRect

Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate

Func _GDIPlusEx_BufferDraw($oBuffer, $iX = 0, $iY = 0, $iROP = 0x00CC0020)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iStatus = $oBuffer.Draw($iX, $iY, $iROP)
	If Not $iStatus Then Return SetError($GDIP_ERRABORTED, 2, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BufferDraw

Func _GDIPlusEx_EffectBlurBitmap($oBitmap, $iRadius)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	$iRadius = Int($iRadius)
	If $iRadius < 1 Or $iRadius > 127 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tTmp = __GDIPlusEx_BitmapCreate($oBitmap.Width, $oBitmap.Height)
	DllCallAddress("none", $_pGDIPEX_ASM_FXBLUR, "struct*", $tTmp, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "int", $iRadius)
	__GDIPlusEx_BitmapDispose($tTmp)
	Return True
EndFunc   ;==>_GDIPlusEx_EffectBlurBitmap

Func __GDIPlusEx_BitmapClone($oBitmap, $iX, $iY, $iW, $iH, $iColor = 0)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)

	Local $tClone = __GDIPlusEx_BitmapCreate($iW, $iH, $iColor)
	If @error Then Return SetError(@error, @extended, $tClone)

	Local $aResult = DllCallAddress("int", $_pGDIPEX_ASM_BMPCLONE, "struct*", $tClone, "struct*", $oBitmap, "int", -$iX, "int", -$iY)
	If @error Or $aResult[0] Then Return SetError($GDIP_ERRABORTED, 2, $tClone)

	Return $tClone
EndFunc   ;==>__GDIPlusEx_BitmapClone

Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate

Func __GDIPlusEx_BitmapCreate($iW, $iH, $iColor = 0)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	If $iColor Then DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", $tBitmap, "uint", $iColor)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate

Func __GDIPlusEx_BitmapCreateObject($tBmp)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; handle Gfx; handle Bmp; ptr pGlobalFree; ptr pGfxDel; ptr pBmpDel; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pGetBmp; ptr pGetGfx; ptr pGetScan0; ptr pGetW; ptr pGetH; ptr pGetStride; ptr pDraw; ptr pDrawRect; endstruct;", DllStructGetPtr($tBmp))
	Local $hBmp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tBmp, "Width"), DllStructGetData($tBmp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tBmp, "Stride"), DllStructGetData($tBmp, "pScan0"))
	Local $hGfx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	DllStructSetData($tBitmap, "Bmp", $hBmp)
	DllStructSetData($tBitmap, "Gfx", $hGfx)
	DllStructSetData($tBitmap, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBitmap, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBitmap, "pBmpDel", $_pGDIPEX_LIB_BMPDEL)
	DllStructSetData($tBitmap, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBitmap, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBitmap, "pRelease", $_pGDIPEX_ASM_OBJ_RELBMP)
	DllStructSetData($tBitmap, "pGetBmp", $_pGDIPEX_ASM_OBJ_BMPBMP)
	DllStructSetData($tBitmap, "pGetGfx", $_pGDIPEX_ASM_OBJ_BMPGFX)
	DllStructSetData($tBitmap, "pGetScan0", $_pGDIPEX_ASM_OBJ_BMPSCAN0)
	DllStructSetData($tBitmap, "pGetW", $_pGDIPEX_ASM_OBJ_BMPWIDTH)
	DllStructSetData($tBitmap, "pGetH", $_pGDIPEX_ASM_OBJ_BMPHEIGHT)
	DllStructSetData($tBitmap, "pGetStride", $_pGDIPEX_ASM_OBJ_BMPSTRIDE)
	DllStructSetData($tBitmap, "pDraw", $_pGDIPEX_ASM_BMPDRAW)
	DllStructSetData($tBitmap, "pDrawRect", $_pGDIPEX_ASM_BMPDRAWRECT)
	DllStructSetData($tBitmap, "Vtbl", DllStructGetPtr($tBitmap, "pQueryInterface"))
	DllStructSetData($tBitmap, "RefCnt", 1)
	Local $oBitmap = ObjCreateInterface(DllStructGetPtr($tBmp), $_sGDIPEX_IIDBMP, $_tagGDIPEX_BITMAP)
	If Not IsObj($oBitmap) Then
		_GDIPlus_GraphicsDispose($hGfx)
		_GDIPlus_BitmapDispose($hBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreateObject

Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose

Func __GDIPlusEx_ObjGetPtr($oObj)
	If Not IsObj($oObj) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, 0)
	Local $pPtr
	$oObj.QueryInterface("", $pPtr)
	$oObj.Release
	Return $pPtr
EndFunc   ;==>__GDIPlusEx_ObjGetPtr

Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-09-19

Func _Smoke1($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke1
	$Smoke1 &= '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'
	$Smoke1 &= 'nmg4oUljCrPWDC0atHqGorza9MkEVwhcKJxGdwsxesNp3R1ffTmtPz49yp1uzdqrPsAOPlNEK7Jd296u37Hx4+9hHOTnPwxAf/6DvOC/Wqz5+4/3B+WI5pOYAB1NYYic1aA8WxhAeZ2qZy8URguLto8kDMcQ3q03P9mXNvrqnHx0htmwRzvhRnl6tSTZ5o2qfCF0/sisH7/NHL3HoP9Y8PxdYrGz4fpKfcSTr02cGGtHqNmsUWFnvBxPSyLc5cLx8Nu4hpl2vAGJYRTNd+8kK7uN1Ghr7cbc9maniT9HxMyWk8AJnAc9gC6sAPVv37uNviPufW+26Q/MQPnt+T7TOPTPiEH/5dOC5/dJv/9ZYP47eGo9sufOa19ZeGjeFhutmo0chLm8vAYeiRVJD17aiQ5+eyXpzkNcMM/bQdXJNS9HgHmJhq9JjxkRY8RSz4VhLeGKg45/tGBQqZ/W/6dGg5q3V+xaaBqaNC5lzO8N6/FfuBr3LP5vdlD/qR/KH3icGitv9bW3H/PI+tjmMqA10Mgw58ywkdiSZohJ8xO2LrvMPJBVkmbs6StBwlDPF4P3dAsQFuYtZrb1ZfPFTSwjv91if9as76dFA0DwvzRoQOP5iH9xGivrMQ0lr29Fzb/YKPTnDtBPyH/6zZ98RZPqF382gzLqmWf9BL7SF21dV7OzqLOe21M5aLiHi3SnaD4ZcfY1inYuREtOGYykLn3O1tBjgnN+flZas5Pv46XW7ophycMXeeFlejtN7JnJZTuYToc3jI9s/HYbENlu2f1Wm1YaG7+h8Zp5g+3vhiz+DwnQT6kUBKCv1IHgNfM/wUK/fXj6gkeof9XCa76pZz3R3uipnddhrQFLgzMn88KHNQwGdVKYr3gMbBSVDLYCJ2QyHmu2Lc+F3Fvm0vMpMHvo0U8vle1BGS8zck0W35F7qEG93Y/PZn58f86bj8PID1rZudYz8A5j8FMAvtav6r1+Cvyynj+2ScenEIN+JgD9K6ZH48NHKePhP+FDPxyjq7JMX9Nufui1NNoZHzZ98aXcR0YNc7DmZtSoKHw1GtaNG7ljY2BlWumywrLcgTC557pMNlumKEuS3JnNOxux5rpE54q/1Cz0vM3fGgThlsP/itcyOms98gw19Y4vb4GJ1Zd6Der1tYJvPvjZ767NHaA/DDwHm77Sd/SfVV/Ur/8TPtT1oA5qCAr9pP4NHuOp9dUareGuoRFRriEcpwbkyQxsN7eoDuYiqckbQdIO9mhReC8z2qlNx/e0StGWuEJk4Rg7RpFDfh1n15Jzm7/nZvIPYATQ/86v6u1t+Kn1VhZoTZiC53I91C/Z9AVXqLsH/eG8p1a++l6SFOrVeM/2W/FY/Ac+NPgnoDWyQUalftrm0+n0tCyDk/cFl9siuxxUetwDwzcNIYSfExuZ2bWLSqweQRRabZXKbdIqfNG1GUy8idbjxY1L0mnWMn3SelsNqKfK9+9uZfrfee1jPUF7f5nwRq8+fIbrq1z8Gm7LzvacTfArfgpciXp7j0F/SJvq34OrF8o/eVZ16J8+PIu1B4zNX/yBV6cvnh6fznM599HONW3kYBtu5CASVrCdwOlJph5yIcuKpLqsUACjqDVdph3XntjCc9JPlG1hfhLuoL5dyKTNLRXlcV5j58p8B7zlAYfWrEGfy9qHtXmrV7ybMYH1NBSauNGGRbjc3uzownO135M2/fFK8D8aQP+qxfnHj57GoQIHfVW//OhD/yPv+5UkDOfUOp1qp7XPV7z54o2f6a/6qZ0UbcTJY55a1LDI1bKAdHVRYDyWKatDPZaVl9Mq6FDdBxQ0E+CC5hdcV5xI85PMr7iTlxwR9pKMp/1tvnqg4teTC18yfR3T1wZjYWwsbZmzv9JSnAgm72ZbHLmA/mr7tp3jmZf11U7AN/XrPyECjX9oD/rX7R3VbzR4/AhFr8LY/6RM3mnEK7fW59q8dTDjR0/dX52fTovbqZGRxKiNEyaHWj3SBHD8DQOj'
	$Smoke1 &= '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'
	$Smoke1 &= '+/M38WtovjTD6afY0m14sPRrtGxxSOfO+qR1nNvnD0/iSDlu8Px+nyh0m7ZojHNOa7a8fuUjtjkWX3/sfYFoDuUe8rLc/JRUF9ULYLHHkjVByUmrOqvR3MMQZstRGK1Q1CrTXiBKzjGMNFmgUkkrSLh56lSSNqH8GOlgZa+ee13M8IJJlVerpYwXpY397BEnOVcS88GZVJZpSPSMEqj3s/26zfdk7BuTTPbr6dyGE07kizlBsyZu00yfeJD391FmCqLi343oBvPDigI9ZtPTQvf+xq3x8LjE2hsNd8K9CGwlrdPpRaGngiZKPo78urpHpj+lzOIIZz8cy9QglGoZAtTJIzWiE6RQKwdaOVVZJmOWpVvIKssKQLEgMne6LJ33DA7InwiFLVkmLE+VWjJJGSc7UjGqM6vtex/rq29/9fJ+/p88c6HlNRfGcHn3yzeEBh5XY2nb3Buw6+v6t38wgP78hwHp78tF57EeZr/MN6/o4/HLTkPettVHdBzcXTAMDYysXsajWgxDnt1SaQtmC4rmCNsPsud0goYppDJZzZp0UrfWJwtRabPAKsminKPaP6vJzMqq6MBOQrUyFEMbQ6nJgyJnTZpMwv1Ecs2uxqymKZWbFwfBT7OKK+9k3vYx/w8utyjzbfy40GnlmulXGjb2Z5t2bjOfA/Wa907SD2EOvGYHJits27Y8fNkZo0dz44TjGE5hD4Gcpax2oV6WJ8Ske6rLrJurpfUsZLgnPRJMaWR5QoKsjh8kTQnsdFntIKssz0pAiYk6qqxZncyrGlQrzJPEBzpaAzVqw2SV4L1297mYSrU44YWTeZTlyQLnauu2lcXG6VZom1BLG0Y7tRc92osYMZb3UcT8qJUfn25Hqf2d+M9/X75/4DXwqjVMLTa5n1bGaYk+hgtfRh71zRqFmjwWqCde8gmTynL1QVVXj6ZZJyYOdf3uU8xWWVZW0yyQibJKGlmwA1Q3w5gBC1NRS0yrSowIicDQQotFjUvZHPUSfeLomkPXQ27cZ7XpeAA5QAQkFtJBMCTNXBHNvHz/TcBr/plf8A5YX3398DCi+z5WlkHajHfG8zXW7RmYv9XS+PsH6M9/eM8ZoJ/Q1F+f+4N8Nj8JjS9PT959YN1p7rthax17M11WXc5aox5q0qqBPxbCRHPigVHuSUW7rTloRXliFGrFUaKSF5AGuKxOdq1z7krA6jT3ggrJwNKymvbsIiWMXGuWqhPKQGVZTZQscsGcGVoSJBIKI9BBOykEUWG8bBWxJ0aeMFYaP3t6OpkQzQNHFsgTeb++XGgfN4X+YxzxP//BoQm4foq38+m8entjr2DY6mdfGOvI4XiFmQWdTU9l5pg6i07VC1W1Q1gx8aUwz5YgdioSV+UDL4UyFkt67ZDItNQs6qVgOXpCsspUGcjSRUWZXpJCplmESRYkjaDHUu8jq8LsCDRauqJkY4ZFtSKnTdwigbKSWiErMkTZrVlx2d5eXrSPx0vyz3h//fj0QIdVe4v2mG91nQGOtphGzk/3cP8LAvTnPzgkP6ZITuhn7fTlj2A9t0eaWeN0OtO824oZOHLt7pl6KpOXaT0SkTwqQVENp1mvbp5QlbfNSJZVlOMFaUFaVK8d6DlJrAbXutqoSWbLqeBZSq+gZVruFCJS7dBkLjwqWEp6nqoM1Z4UvLNRYaixUdF9VqMlVFI3onSZkiywigzIDS/Gw0NuP37/y+j+P1Ye7cRyUujixmp7WnmLC3gfj9Of3m9xAS23ZY33JOkvmAB9D5IEroWl3uqnevXq/ObrPsY43proY411bUd1nlsX+wE08kEJnPKMl1ek5s7O2c/VbMG41lJWVK+kKM0yWV0FkSiLoq6ZIlOtvFJZnfc11Spyo1UywyDT1nDBzGZg5ZZlmtFqinqvk5zAag/ltOan4CCS5KgXzRyW8rqqpaGsynIoI9KJksqpXvJdfrL25mTPfrL2OGjIFC0qy+R6tLcVq0e0cy7jueb7ltRXes03'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= 'yGZSkqT1TBtuuFJJq7mWoYgV6JVs62YwcGOpWW0obOiOSFFOvEhOA9f0myB106zhDtnYKJvV8jJgoPf5LwaNj59zJ/+LVjNZs7vVGkSDN4sVHcDKpezlhuNhT8c2S7/XEjl1cwWue7X6FXdtMabradgOdPX5yGGbpEGUrb6trJpKVGroKSnYmXUZWGBlgZlmVuSsy5rWOSiMS8jTVYjUVHJpaCbMgqgsKvPMKXQtLo4gLTCZXDDD8YWaW966bMv3pFOlYd1MTkgKhkKVUxODarZCc1Ir3RtVee3VE1yuT0wHraqkSyhsV9FqqcAeGnoJX/IoXgrYIzdPHtwq2sZ3P6f47pddQXfd7HU8aRWJYrpHvDBd9tI51eVO5kEaVpXWKwMF07aabM5IUJNqX3t5bgyhrk0Z+3JKIFvYb76NiVS1eDWw8zAHyXI5f/JV+GwrMcyXTqlSYggtqcdZF1uetBaEZeXEHSoEVvn6+Zu2vNqs7uBjglmZIecydFP5UFlbF/JarCq91SebNwvQaSFsDRyStK28Nh4MZrRX4F6QmTZZgaT9hZbeuNRBVb1VHp58CF3rxde210r3q54/l2zkl3xAL132LSS2wZUzclvXlMIB25jC1iZns0Gwq6yb0+UKWxq7KbONTOhkBU1Nk6jipout5LuVoVlY6ATfleVKTNRVLEW6DRv+yNSgGHwbcl3tprP+aF+crPCCKTJN2jLBnu2wvdbhCQut9SWaQNqQiZhr1jphhth5YqC0qMn5ssp1ht2RTZnClPIbILnKtoXSUdPlkAsoRq9hLXth50qlW2jx3K1xCXvXDwq7lB64VTZjnptbUYaFbfZg29u8UaDrP6/4YLM7sNlX+wf7J/s1wY/xA0z++fkvF0anha0wrIsXzbieykJuqW5dYQeoqXlX6iSpMtDUZm2VS3PgsqBhmM0agKl8M5dLVbUkoU4vU6dqoqpy7eVSTU25XTAf9Go6C/M8q3Lx5loOpJrHZJ6zxBypsjkXqY5LaZFnJVRJ3jSroKJmUTOlrJmlSlcaataZZbXnVmSvWamZayUaL62rsclzU5ZhNFsjp6EilWIZU8nRtZsL3bVrs1c7S5lbqxuHeUBaOP19+3sg9fzPKx7CDg4+rdmvAHTYGiYHqznjj5+/7RDEFjg1KRUU7mw87FeE3DsoDYVlpb17Vlei6hrWABmc5mqFd2RO2lM7XfhUY74Oo5frWuRjo4ZcJHJVYaMuwcZgo+SZ4elRSopkKollEpbbs5B3n+5uVVPkD94ro6xqWpMzmNbGcDNMLwxzQ8tPokbJLMga3m1WvGwte52OR4aVcNiY6gZJyWxo9ZilIUw1Vekg1CzpQ71rzmjoi8yeeiwEhIZ1wiovwzNu/XoG8ydl4m/5gFrjIL6lGtGscWPlWn77XoPYjuPwzqdyUT3U/ChEHqvVUnqwZRrVrXOW61RjclCa2mxFaZum9W+SFOVrJHVjcGgSlLyuQnuJM5fDQ5WM5aVUydfAh/Iyz+H3pR6Js0IBZJ1aR8St5hWoalrzzqmEMsmjyoc2xFSrxSHzWlv1wjLaXJ12ycsCA6Z2K6PKW0HRcUi85Izy6DVI9VcnXHSeuutTayCcSsKnxUgjyODwJ1+FX6BFBThx3NKyxf7+x4f/pqal/rMH1SefbP6PQGu/qWktP3EuNhrN4v0ffvtff8fXO+WDtI2t0BPn4m4lV5hb2Stqy3YLvBy4qyGjoFmAXaSWne20DpiZZjXf9aCRChVbTTmltKWk8zpraCQpO/UAaqmg2DPNrZfrjF1XhVLhhhQ2VNUMoWddtnfkNUQb3Baoxl21FrVNZSBTlZZ6yUNZ3cQUbnLKVIaRtHqJU0o+1WyNl0pFy7Jch9FKm93qolep00Gf1fq0JFSeygyFBW882WvEVNBFpmGl0mFPaLfGBe/8/m/3gC60zbQ3/d5+R6P5133jzuZ/Z1s+HL/128avvv7d8fVYFge7L/UGHRJOhaGgslkS2mxn'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= 'REFUCFivxsOrSt2oFAZV+xJHRnGv9KjLyR7r/625GGhNGvUSZ05fdS3XtHKBF6swiLwWboFiGo5FNobt0XqootQs0yy0QugQFsmrf6DCqCCzMS0q0224ODUNuc0yjKisac3RaW4VEXlF82p6qBiEXdbMVyanUU1lM6VLXiZnmKwhdS5SV6V5zULn6k2XCNtAZEaQOx+6fK90kd7odD7tFsXl7pR7s2moCjLTciXSEYVQ2Di2unyzh1JsKCN6s2ptzAnH7Xm1cx3RP0Ni3V/ugP7rNxZ22J07MPm/hd2O3x63/v7d14Mo29sWm+3dX3tBT1cSNcwttdlWZY1klxFWavqoJjQVZprWVSSDbqHAEzvVaT4Tns2BW85WipJjg0VZCtmL36AZdsIsnMIluSe93IosfEu4CIV9YfrnFB7vjZdJoxFaIDNXya3ssrYoe5W+rCEpyd2U+QqxUbWutBIeclDz0DRTY7amWRFOm5dNqV4LVIqJ1154FaQht1or3rpW0IKHPXBGIulRYzWNJF3kAGBPp7LF9YKlBt3cnLuBY4ZhZaL5rEOfKusVjJf3AdL4lsDsN4KLNALda/rVm5zPaBvMB2Ycf/oi9K9wxb88RwDN/tGm/fr9dnvf3u/cbjHbO3vibqN1c6JCoSdRbiyLsN0Kh5M3TjVduCKHhOnzBaAtrc2IkxH0ah4QQWbg9ohSBx7WzZTyCtJQWwMCzQqykRjZNRcEVFHD3UA2CnL5fogIw2hNRqlqsyvWcS/CzIa2JdqQyJyYpDRYUQdVaUj43D1V0aciZebCbEVmVym5RcG25SmTF60bNQxfpDu85A7IF1LBXJ/acU2duK7SpE5NpYVkW5VnkBHkB1sMYDfZZa9pdM7WAI9wLNnpluYM8YJgdD5YetLSigzL+KYtDaN2nbyJeVnz1mfMWNX0z5A6/1dA3+hT/4Mffvx1eH+P/f22de/Ria9tb+3wNlqorCpfUQinSkUQhYZTvXamVJMzp07SWmm5cNjY2Wl4oigwf5LfoNdBFO5pW3RDcii7VjCC7OWLSANUJZ+vj1ni5aisIejgl5Jyt3J6NOuL32yrEBkEpilhWsojk9PKuECxkorLFUK7d9crzJCskgZik4W7W7c9GlsLr9hoUdScNS2EDnWmn6TxLQiXRHGCDxsvFj2z8o81wahhWY84tS74k+ShmaehVfvDUbZJhfvw6clmZi+kr7s66KoBHvRVtQ3L/i1SJNi+hXrqgFe31Kqpvdq7X3wF3ezgYAfa+mrHrw7a28Hdzc1JNdx2YNYQ7BprKfliclIrqOA1AiwJzUXwZNSLfUx6MF6Xjug2olMKv3lNYtDtQeiCIst4hSLO5bXw1yhpjZ3ICps8tMfAC48VzWCy0rQWm22GtyZN29brtoQ0XStWAVej5BRWDf9GprcSFsY0+4woZ7fSehZmYZHhFSovWXE0i9M9F3Avq9GFPAcdOXrYBYoSD7BXXdNU84gw8nOer31daIA3ZkZ86wmnIRZSzSfhg/0VYZIRoDPvgAczPbgmKy4iqpa1BqDp9GtQ6+AT29yyCk0a08lk/9Nr6F/ykbR+PG/2hZW002yTb0dE3/bcwrYWYKGpBREM+6TXVKMYudsKaC9h3UqbQldmgas407XiXk9/t1oIMUPpG6iwpQkDpjdD5VGyTReEqwSzbMViW2kY0apsm9Rl8rkId8DwqP6KfSuDm9O32GO3rcIT2Iwyy0WjXd8HVdNY/9+4VZmwruFOleyifJ/fJgspr4vmRRmqF3spKKX1liijcHKPrMb1Iu9PaxWyfBrc81xAH8HNhve9yy5qFpw57eZdYRCRovDZmuB0LF9Qh2SPYUCNYFGn7ETC3KEb/rEAEYALNntAUVToWhmgLXVFG7Ouub7yGiWefyoy5y99QIPke97W3zT9LfbALj/c66nfFoG9OPJO9VrlKMVLMNese1SBZ0WldmZlZbEwNZlKpt+8W6prUtqRTe0xVpomWKo8hJsE'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= 'jXmwM63ryVSr6WZpMGtzyDwr1CgdtZh7h7tToWT3p6UmXwr78H1e2EVQYybsPGta417OWRsp8iQ0rSkutX0Kx4YwX5RnIddcx1OEr4e8FYsuj3mdSk09VxAts/BZJ6enMGfkvmQvLJPhqEmlR+UrmDg1FMDa36dTeNewRkDcWbM5apgzrdFtkOUWNNABXjk9oY4Kc9+q8hSZa0gBOsl8VBqiZi653b+YTR/MtUj94x3QIOxmThHR4q239m4Zd97CYUMeQZ/keXKHsFTqTceq1VU25NUVKl50TjWGCmpKK8Cquqmqwuf6dRYoEHI/jTUwXTpkoaNS5qSZA2WHMtOoVEZAwXOmre9bykSntxm4arqfXnpUePheL25UPs2JOvElKlljb2s1bXJP7OUOqhVLw0tGgETXkFMabGqSoZVlD+5lQLDyOGLgrBnrXAruSi82sp4VLEEcdrPVkrBuSlt31ZFYL64o7kOhBdfDegwddmdakIKdLxxL56pNk2lWQeo0q0kSWQyoilhc5XQcIhMbRduOJw9Op05NrvaTT9ky+hP/Q/OP2cWH3bjxD75AvmLLSYKeG/4eEe84kBbF5MSP3GPUr3a3ajso88BUuHaZjZpMjGPVVMJKp/Wyda+uqYAGfZRfv5o1nsZ0EqS5oTJFVtWwXpk7swCLOdrQzkynR5LsHEZlnRUUqNJVqh4jmwEv2tWbbqjGgn8n8ppQTT28jppyjQrPesYy9CVukHLz6rS4SPyqcl8tUl+YH+uWanwuDEJp20yopqJjphUhk63BpMxp+m0xkTU4gvTVxReMxJtKI0frQFmjQKlozOmH70w3QqeZZV381JqWihq22kXkVDaKoNUJyWD88zw5E4/8WP+bf98iaZC8vmfH/wEP6KnTvvBvl0LkZP+SRZHsePSTsL7CzUVuA38k8R5jx5grT02F7deizVWahGY+a7fVLJRGuYUPFU0oKKHEMwwGs9yc0LAOXr6PY8Ldyjab/KKmJ5UYc8FgyjNLsUZXhLCRKfxwV6+cw6nmWcGMRiMMDStdfFANTGjaSPfKzOk594ZtDHYO3Y0FVzJ3K+QLPurFJMy8ucfOYYtaUjbLLRYl/zwiKoGugdvpoUwirWnxkad8uTrp1esARkFnqOM58Xxv4E71FeVjV0ysgoO2giD5DBRPrXyQhBq+12Ge613vmZwFcXIymucZBakqfGb7Xn/+U+d328cf2Bf//etp5jHeehTKqp5X5nG/Ifpm8Gtuch+zonOoMS2FKKfY66H7Sv9QSnbUVCjLLX3RMzamwaF2uZOiULfLA2WL8tk15LFrOpo6gMOqIOmxSPMO5gxRC2YzqKDCQ1jSs+R1WARmCS/fylXZIytxmr251y/sImY1h9S97VVtqKvwGr6xmQuRZzVAlpDIVBY1bV9gSZfgkH8ekVrFCKCxBEg6LaIIhOie7P5EapKl4z4HocGxAhrt1OnEv2kRqPDV8VPEZNJoQp9PBdORQXzKj7zXUK8ETW86VjQakPqwSfaLuVgz8Zmfm/ibFU3Hj97G/+AmSf+X/f3zK1tT1nbblOUz2pOvUU53a4ZPbTmr2QSnpbU6ry5y9bhuH9XJREOTtuKz/VWYRcOvUv8ufKiTNmy3UldZLzCj0klW7KCcahgzBGVuvUbzrCr3FbOVi5rshtx98UU0KO0Wdszdw7GWw7FbrBpQ9lSvb2AexR6phpsvmrKWA68Sk3Z6ZWxMVGYr9MFKJJHDurlSpbL9Uhl9mImqi7u9GJAZGAwO7e6G9vDajTpsLyyhx0gbGkxSYVH3CBvmWnFlnySs1Gr/Jpess7BpEVRWLsgtfoU+DvlK0VsmPPBtz3kKT5/a7LVOojVNgmZvSuOPvepM2z+1LbZ1etxo1J+iWuhu4VhX+Rm3taPOZ5t1L2o1LcmCHBbU4V/MJwWnkEmccoHR6Fr7CmkQ6lYVKh3sPpYuhZCbl5Ec9jIj2esQkXMRMIhOhkNu62HtsaaP8jXjo2zB'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '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'
	$Smoke1 &= '+tPXiVyhUQ6iUt6yPGJ2xnQR3bBeYbvfVqBtyFZPvq1M0Qhbmys3lQhtnnJP3Pd8PROdhNOBBwGzm3w9W/JZ08PJo8Ib3W7+cBnxqGgMskMe9+ff3bW68+/r02J7/k80n5ev6T76/Z/oR29/GqLZV72Z7P6vvnB0f6m8P77w0L+DG/HfeduisV32myuiERE07OO2Q4tcPTiV5ZXaxpm1nkOUtNUQhcmVN6MkZVjXcAdb8hQQUR5pD4nbekGzLeRCXU+W8mt9NIBXPxe26uDdRK9DZLMjFTMnvYjWnA+AIjYa8U1TSDOUKLI97vdPP8w5USVv9fwH98uwb+3lJ6941aevJVn+/f/2z/sXfoJ+Xddn/WC//Ul5vqMa44uT9fNrPu/2IiJqVneI6HEz2S0eRvZOu61Ql9wJrbCCNUN8sGfUmwTjQfherySwoRRHRuwpX6W7o5BJcuwhCOt6ALvv9hSx0wnrdfVRZEclIx6C0M5RLY+8030u0n0gki1P0x7+gf8mEmcy5sjBc/6A5tlGfvrvNpdvYC+fT82/rf1rjep//yc8juxPx4T8ah877GIvtM+WWT6T8P7+mSqCBvGyta1dY3uJ2IjYcSxMsScbuhWEDXmhmB/Iek1yH4B6f0zUi7q5kMHuQPaQggjx0aidHucsaZHllpLT3tNCu4ctoUri1Y3q1gk07t4zkGbO0ZmJTz+fAtpgazHbdZ8bNGbD2+T5fM5HW3P5SlTf/Q+7890aHwnEa50RFX+aV/uv7gT9uqdoTe7nJ/+N/dgUtb93b/386j+hYTIBu684VohSRAWPDKfIlpPd32BmbtVhdDE1Q+iRsm4RarcRFtazR9S+8OLWq+mIWyasMNwiejYcRVcPStIWmRwlC1bIVlS0uyKpOebzzo+zh8bsODY1ve1P0cnnmW/PaG/nw5j/kf1/Ojrq1X9MjftJyPb/4Un6+z/tUfSraZL+wQC/ZAvTOPmXP+nn5+f+PnjXlGItulGXAtEVjXzUzfb8Pm7+Dc1mAjXVq1eoF7l3UqVBYaITdqfx/7V3LsttXEcY/vqc5gwMyXYSL1L2q+n5+GRZuMrlpGTRnMwM+pLFGYCQzEUkEwRpnX/D4oIgLj/63v0vqeGs7QQEHmvZggNZca/pwgE8hjLEQMSaQzpxMKGyKiaOR9OIc4ZwRu5sjvV4miZnKrqJzYNT3bytqbTTt1sqmAfAZf/Fc55+KXK+6kL9n7Khn3znt97y2y3e1FM9yD5dr5WdUKjWOirutbUgid9LDXIpCDHG+8MQnhyw1cn1UJPwdCGrUN20WqyBWGnlrCUr5tqUO6LKgEN4EzvMFY0lkNU07grUINdS08WbaENYWlFf1inN7BSezPlB9jnKt+31ZILXKMBCbbVOkbzLe1b57jkvKt1eyRrJc98lf7pIFAfZ830bNz459TadeYDmbqnojcKg+1J3N3tFrI7qTUCr7ktNZ7BVODjEMN+FO4xwWGR0Ew0zN4Sy+Nj66lAqa4GayL71GGXMb2TN2ox5VHVDPN0nq6q1nZa1TS9UYyk4eGBTzM215+/MObcYWnTbyFpykRHlDTM3+R6XHziwnCynf/lX/FL0fNpC/Wt08Q8xpufEIj8c5bq3jPU+JsBlZM8eUKdwmG1XwMRLzelAHQG3CQXxg8viyH55HzWcyuIIMW059ChLcVdZYqy431hQCC3OEFNSneoTS4wF84ChrIuHp/kUQI7uUst9aKC48msOomGpsXI81jttV45bQeg8dmz6pcfffvkzodHlbee7125BLzBSMID8ICUDmPGcN0nFvWwEhcKo3ww3u4GbKktqrekypBenRk2iacLVIIkFDfM1h1AsRjzs0MQPl6CokDMhOHVIi11B5lTXui1qlBqaS5Aerfi1tiBSLBFtV5RDpWQwnzcb8g5/pJ55ZTwNPb88QNBrvOQnpugK/JZj3m8dp+EYm2UhJXBqKJYaH1JjX80Rq+QsGopns7tWNJwqLurzIQRf'
	$Smoke1 &= 'MVE8LLSaWyO6mKkAZYY0NCanGJGTDWiC2gJh7Jgw2FTv9TgnkFumng/3Ot8AC8iI5fzQnX9t5LzM47xeF/9x4WnhYRd0mx/PhUV+Oiqr/7f6vAfsPzfK6gPKDou57MKyUc2CaihzUgirrfBktFM7xEppN+6zDfSRuIVh3i6XGrpNDBkwYZkY93lf/r5ZcvtoCbjJO74FKvvNoe22KPRV0vPdBUiu13rpT2xFHxdQcX7n1O5bbWXHaNuI0RowlIgpymlQzVixWJ12aTRIci3YIFFKlHbMJlYhSsBRow1gRlm2Vmtrui65YrngDDnJiG629NiEdSor/9i+Tlt6JwOWwGucfr8EPf8yFvTRDNUZWHJB2W1zPcw2M7Bjb05t1k4DLHfizGDoCmrS9jkstKrBGkM7WdNsqamtW3P1IWFb4Fg94MA9dtId8kSWEw2PTdgR24aJz1MYlT1TXp2gty/kMa6SJF0sWfojaatoTu3nRtPasqq3esMNpqFY1YIX56YJXptaEDgLgeBqhqZGE+kyLCyPogR6NtjneC7bBeN6arj69jx2MmxneNvwYPvL87YsZ2Nx01M0JZ+XWu8uFL/KNfUZ312aoA8fewWq7DBG3qrstW635YWiDJUaaWjOiVB2bgfLzUQeSEIbKcWaiOAWQ55GkzPObGZ9ZINyAFFGXApvPiLoI/Y/766Xzd8+wSf5lEX9q7r4CwvS/uHUda7AJNjbuxgiCSqjiubUDjsmqW4Vt4MpK2nRukaaGlYsLcnz9+xo/RbWs4mix6LhFdJZqKi84eOjPg813CNZ62uynZfK/f9aMehn2NX8wAd+WuXIjWWGG41tHiotVWZXt0VD1WzbwId4kL86zpsefx8fHXh79AuTiJ8eoy0CtsMPtqmZVBau4uC/nFjvLkTOF0DQ28tHop8mUr6559Ic7WoorDYwAgVRs/DDNmo5H2XDmks+d8V2Hnt+TlT8SYHsZ9lnE0LUY/7fbecLiUGfKVl6JNOXPcobuTl7I3QHlnrDYtYOK3GWo38adZ5sYk4s6P+569P24r87Vj0h3+f99szOXfwzZ/G3T/L5XWacpFydn883J3Omb5FTfsh/568Ph11zWZZV3SbW7Wr35sSPFtfOxBj11AwoeZ9L3n/O00jfFN407za58fX0PPxMieNVvf+X+hS/vhjUz6yU5gTHKmmAubcNSRZGDiIZzOzkYbGk/aWeMvX5s+h01BqujK0eev27nbcv3MC8ABf/rG7+E3cLrPKjlGy3j6StUeQvOMiPUjLyZwZ5I99yXrXcpk6ztG3Kz/y/VXayp+bU9te/At/1+gl6FYoeS+mD/BPLn2XP9yhthbfKdiF/K/TvqOweDiFsp7Xvv2jPfEuVTp2mF07Pd1cl89fn4v/octf8FzSLtpXZ26QpZ3l6O1TzN7nBgXvWP2H7jo/3Klz7den5gizolWzoZ1m+bZt0zvXa1u+5XPtlM/RXZkFvXzxF05gYidd6a/NLbGePQV+TFT0lVl+P7bx2MvXCCNrR8TFKfws6OkE7OjpBOzpBOzo6QTs6OkE7OkE7OjpBOzpBOzo6QTs6OkE7OkE7OjpBOzpBOzo6QTs6OkE7OkE7OjpBOzpBOzo6QTs6OkE7OkE7OjpBOzpBOzo6QTs6vgz/A5ASnttLZ9HeAAAAAElFTkSuQmCC'
	Local $bString = _WinAPI_Base64Decode($Smoke1)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke4_336x330.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke1

Func _Smoke2($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke2
	$Smoke2 &= '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'
	$Smoke2 &= '9B5RlwWZlXz33Xf/n7KXLLbzzjt/19+CWSB7jpX204Im5mGSst5nAbgdV+sI2AG8GwrikYlVsz13dHTJzBdccMFPbQhUx2VoHWPpgoqdPAdyPNfmLcCVdQWowIVlv6tqrppuqoz3kpHD6rGv0201b9y+fdX52/fGK6nFAdlioE1Xx6yLpGzY0Tu6lJqbbhPBG4AJUsHKPb9vv+zBBx/8Q5j3h/4WzB4LiJutp9jksRvGPKVRGLuOEnGV7iNtWNXg7jb6OcBdN+Dl2IZsbwSgF4A4bKxarZx99tm/UADcz5vFi6ED5Hiv0w2V/uR4r82TElVZlhWknq9abiNgY+B9aCTK9g672yBErR5V6nnjtoTH/ttXw7/hbzwH8NSFE6ZN98bobIkKN3pY58w8Dyv0eLyuXq9NN4J3p512+hHP+vGee+65lnLAAQf8SEAfeOCB32P/d6zwAjPeWO819+LOu46iklvpE3UlOASwgJNZBWerzQVetjdW3AZwGwhuRUYGUL9UGvTrCmZtaO8Tz7WMLBt3H/MC8I1Map4EtvtkWUEqYM2bKnpEVd19YXdV9HmUWDzV2sXjdxjMnmVn1zcUyIsCeGRaQTGO1lF9S4xwGGD0rqYCzdMEVrQq/DcjeAWroN1///1/CljXBsxr77bbbj8R0LKxKrUgFvTzftZ5wzJGXfkMr5uzbzzQAlD1uRl3Y9JNAMqmitth4zDyCOYA2gZAQM+BPLKxjYaNkSyq2CgJRLcFbhoVQWvDos2tui7Duz060jzXa0dn2ahSLwP4G4rUJV5r3h9bAQcj2ASEwBm9o2NUko6m0cs69msGXIsxoxXQiqzKbOSTwD3kkEN+xr6fozb/fK+99vqZgG5G/oEMKiDjjU0faRxC8WIvNlDBCp+wSdlxzr4yrqAl3Qywbq64DTDdV4ysei2QA2ZZewT0CGTBZxfVqFbLyGFR3zlqsvlJQElscu9lwxK2j0e8871WHGZjqGca1XnQx4yFv121+1vwtisBOCqzwBjBEO9oAhniIQ2o5t0lY0DCOGxvDGcMeA2oELg8e50I4P2FgBbEUacFsdfbmIxagJpANAMBnmdEbU7kVcDbfbylOjdANwNcW7C95QknnLAVavBW/hbIYeRRtRbMiir2yM5xfMnIqtXpS9beHp1dNljmpfcV29oXLWijzvPcjaIB2FAIalk+IE6oZ8pEc8Ey8Lu1J34K4Vz2Tn+zkTwNAhC8bUdNI3diq+kd1ckSVVBWG1U5HSupRFakxAyPjprYfImGsiIL0ERDAeJfRgD3ukZICWIaiZ/IYD47scned+wjjWMo3tyoqFFPw3ICqxlONt1EphW4HP8V+doaUG1j6m/3j2zs+X1N2cijdGNQrCyQBXGYM4wsK49iXgJc3m1Dnl2aAOWxGe9TWkDUeRsKu7o6Ysz76PmurivLJEEk0YY+wx7+Ztfob9nbLQBwbN4w2egd1SNqyx9VMN7ReZdJxtnOHTU2ACOgwrxW4v322289wLr+KAZYBMSylc6cxCbPHUKq5Ery63MEvRU9HmcBJbgEQzPrFrItrLsN521LPrbjHtuTr+0C5JGNBZbXkY9NeMeNlaWYeQRybOSEa/q+7hOQ5kXg9r0rPzYgaUQA9q84tqXHPW8EsSzutwiILW+/W7rdxqitWSTbF6nic3/JF7nH8jVfQQlMgRV+cAEsg8puo/OnY4LLXouDJiGG6eJQnUsQgkCSBQPaeFjDhDKR4BSkVkoq5waykILKXALzbhAQx8trpfVedrcoCWtMaiMTT27boBUu2TaqHuWNmuW2bJBsC4C35zm/Zv8OCnnYQSA3qLdWrZaNo1bLjNrHo4ygpotpo6jYAXI7yypgxHcVuDynnGY0GFsIVBsNyqTyYh5M/c32tgK7WXkBiC3PceRUAj7mUVuf4tz6rCq1VATeZ123fPzPVAILAKwNNbJvujfszpDJBIWSqKSAWMYbPa3xrgo2vasGPbQ3Vc+qtlw5aqzM'
	$Smoke2 &= '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'
	$Smoke2 &= '0kNh4SN41jFoPcfBqCcAzBNNBbGgbnAfyr4DVPN1vGkL68FWs2mfwWaaKgEx/oF1NXd0JPoNVanDxH5ftSyBvJiMxzKpQoAe1o7KPTDxUt7qZZv5K2xfxkW/ajK1BHDYp8v2j9MNZKsu68q4AS0ff2MrTbzKOqj0xgrctgeLdbsSy7QCdB8BxPYB3OdAzj2Qaw5QAqwwpKlAy/mey/ZBCscOVth3iL+9l/f03IA69wlwPe5z+j6yX50bAKs+axsLXNO5pFFIOmoQbgfcSd2XBshGpBuZ/cxDwMuzj6AROQrhscceDyhPVFDjC8ACOwDWyaWqr1rfzrUd2p+gE3BLy99vYWOqh97Gtn0VP5uDOF1NBn4oCU3N76RqYyOgA+RRtZYAVgHIX2E1/vbdOjbJf7HwbU39MLKvgxT0Xtqf60eP6mxlSBeNIYQjaNvGnYAbWzf2nuwlSARjA/Ug0oOpcILvUMVt9ykBqel4Hs85jH1HKGwfmZRrD+feHjtUUAtmnyNgI+4b7+v+AFhmt3ERsGHabAfEgttzIjKpkmujQURTcL/7RuB2A1PvlHfhvKO49zGCl78TYOMTFQEsIwtgGRo5VABrt6vWt3NNM0O/wHYysQ1nf4vNOtSzZhaZg5h9P/Abs/+7AllprauGXs7FYwF0wDyGa44hmzMwf56plr59KPwSb5ylN8t5pVqkKmUr7Ef1A2s7qX6phqmO2aIbIijjcs5mAS2gMKihvKxcNzlr2kbUcVSsO6+8gi5g5H5HKPk9HuOeRyrsO4rjR1NJj1XYPo59lXLvYzwuqBsYh84bgjB29jegi4EDQsEb9lxMhY86HlCO9jTHyq5W+p6Tup53Nw/dWB3eDdDR5p3yO24Er9v8HQ+Ij+XY0QKYfYcgB2qz25jIwjrVbCR1/nHf7dth5rfYSjZu7UjzZv0RxOz/Mfctu1ggB8x++/weU/crY9/yCGQb/0zUZ33SPhbIM4/1l6iuy5daAgscDQ4xi+0b1Vn29aPKvgZmyL58/ArCUG0ewTsCN4yruqzt144ebVi9vfs1C1blbaY8YgQl28fMRXAq5OE4hePH8/sE7nGiwj1PSsoz3F9A9r42BGFkmX0uYemo26sK4BG4AlaNwnskdTuMr5oe1g9w56zr+7HvePNPmfl3kv/8LYBVq2Vo5HBNBe+ZBkfNwMaG3+UdF8g8bweBzLZ+h2JjpFTqORMHxDbWSmLJ8zupptR4zsjcsvIcyJLBEoy8bAuvhnYohVhT54R99Uj6MWxh/Vh+XD5Esa8fXtVZlUzm1daycsi4Apd91a8pcNnW+6uTZ7J1rcQNmFJ/G2BHC9gwqOAMQLn+BIV7FVDZf5LC9sncp/54/qmjkI+TG8yCXFb2/hOQBY6ADjsLBtVpwbYUA4eJuW5yogXAsmxAG8D6ngFs37vMgZgJg1ZRrCtAR+DyW9SeHBAHwDJwayaHet9uJGR5beo9zZ957bLfhbSAjNidtTW/t/S79QCLBep0QCwbB6RuJxx2nnos52YEVNTvAHmM+krQSPqP205eBvKXAPIE4LCv6k/6fee2r+yr+mULboSTkUUBry29FcUKIwtYiaxQqpVW7pF120YtNZjzjw6zCtqAlP0n8/sUheOnRtjP5mmcdupp3PP0CM88I9vk22P+ndQsPanVAbIg6HyUrSy4EB1p5cW20QkYfJfFVGgBLHgFfdi2WXEp55qg0y638aj35/xiXYFqw0N6CnIqgD1N8bfvIbg918bIa72HjUE3iNXwmBfzHg3C8g+YZWTEvnMDTLby+/kdbZBH77QgVrKwW343uCssVhlDZT0muAWzDC2Y7XaMrWx9SlfUnJGX57H+T/R+UefAFHVlTKzg1faVfbVxbIX9WLIv6S90XLFvQSSVzGvrHtblY1ZkU1eifQWFTNGVrVh3BC7POlbgDixbwBWkpPXHtqgt4e9MU+5z5ihUxrPyWzALcFk5IBYk3VDIYDYaRwXMAUNYOEAQAIJY'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= 'CrxsV3cR5ywActiYyjw5sji/5tdCqk+Y58vCNfMl+5wR5BaBZ5fRTH2+T/ZFHoJ9S1SjBwDbrXSXIpAHsb/4NtVxgay6LIABziStPkeNLgBz3jXNwpfwHq5oeI4glonJp+r0ibz/Cfw+jjwfK5C1j3Vycf8juP9hpIdwj4O4n0DdX3Gb9zrIYzz3cLaPYt8xpMdSZ48FwMeQHokcyrvtJ4gB7w7IlsiGsPHPVaN7DHAB+JswWfvU1xv2XUptBiw1KF+3fdTmgFcng8wb8Ko+LwZg9rlMRjmxwsBcezjAPUr9ij8D408NeHlWza3E75pQHFBlypcap/tpANZ5heh5rhBIpFRn7uGwPbuIHgOQTyN6l1diXs4t8HL+R6S/RT5GPiEfvyNfv49QGX9HBfyYivhb5AMq4nvI21GjSY17HgH8INcUeHkvwzEFpn2+glhgTzIwc53PufcoPLsG+ZPWtDxccxvnypy3Ublvh3HivNL+vW8RFboA3HawXUqq0pH6rYda9Zr0dkHM9k0NXp1WgvQaHVjavgG12w3gK2HPS5GLyNf5glh1mnI4nbyexjucQnoy+08izydwLMEfx3Dvo7nHkdzrCNlVQMqwvNPh5PcI0qPZfxz7T2T7ZPadYsr7nEx6vMcBr2y8Lw3VrtrE2sM77rjjujqzyNN3VaElrDV1utgF7GtHtbZvQiX10I3DBKM2A4RiXvvfVJv1OM+Zl3Md41vgjf2rCs155YWWhbluX4Cw/whgth3o7XQrJ/NxT5d5BS+V1mifmvmfc6ZFs7lPDQUUwIt5ocPAAbC2L3Jn2Jd0zr4vs+81rnuTtNRmzn+f3x+O4CUfvwMwvyd/f1DI3x+oiAL4EyqjIP6QylgsrBotC5Ma5PGMKjTny8ALACyIeUfBeb/MrHjOoGYXoD3ueZ6PGM5Zc2apUnPvO3jW7ZCTwRp32O9r15Eq9KoAGNDokVbu5/s/oAAit0vFltW1rQWq4CXVWXWlqaLazLOvNu1j2sGXI5e0Kn0BaQV8IGeT37PI75nsOx1AnWqXE9eezLUnAU6BeXxYFTAeIyj9zTsd73G2T2X7dNIzkbNMAfIZ7hfYMjHHD+L99+R87eHN0TzWQ37yjQSwrREVtoI1RrsXcExr8wreHki9GcCo/l4dVjIv2y51UeC171cAs8+pcnRgTQttR40mrSgs5BAAUn2/AljbFzkdKQDLvII3InBVn2MDy8LcvyKxRjuY3wZxOCChGFgAD+qz425j+9pV9AK/X0FeHwE8sG8xr+BFfk+eCrwDgH8fAFMpP0Jk4d+Q6sx6LXYwgBTAj7YKXWDkfo44EpT3s+3MHA9G2PcQ5xhvPYnnIIZz1rUCmePlneY5pf4KOCrtXQZuUPkLwO2B1oGlF7okDGx/sMAF+A8gDyIPK+x7qPfLzHcMABao1ferrWuKXK7a3FJ9wwJYFqYsLmmn1kWCGVmhaq2Ty+4mzj2b9CzucSbPPR2wniaryqjUy5NgzZNMeZdTSD12BsfOZvtc5Dy2zzft3wJaEKtWH8q1JPvsqBpNqjPrp+T9ezLwoEKvkXbvONvGXwXAUZ9dpdxxvnYXxeNMuhGDFiaPcwbnqzaHeQFAgVf2HQEcR5YsrBr9eQAsAysycNu+05zGsYW53wRi7u8sFfYFawcbNvmlAQxgSnWWfWcA/v3IwFTM31JBP5yp0WUHc54x04/pgW6mrRk4BKTAZFunml7xCttU2F/CM7PtmOEM/i9Wbhv6Xp5dIZJU0LupqHfzTe8xeEMAz7qRHrA/2KAOVWgF0DyAPMh1gvfRFmcXeVAWblVaNVr7V9a9THYVmC2XtMqs2lzAHmTc53ZJgE2eLyTPK5DzeP655OccWZU8nkn+zyDvZ7iNnMVvjwnWFciF5PkixW2uu8Br+W0jIFOrfu/Lu+zE9pZ2KY0Ats5/Y1Tozwvg9Pdq+wbAgpdKN4F3BHCCOexOgqnLmaUdjBysDTyq0FRQh6jVMh+xgbV/'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= 'dOxmSoimoA1wZWm7bDwv6waNXVmj/TkCmWel4VjVV5j6xAPgdCWNYabmxa4lPdGJuZ5Ff82DSFb1+cvnLZfA17oECsDpbkl/MaCrmUNk2IRnyspKfhuskaivrGqQfuivAsCjvS5QEx9udJZiAIcgtitJhk74JO/33xZh4a/1R1nO3HIJfJ4SmOzMsZtJNp6v+RTGNU2kVSKdEjSRxmAJFfoLM3AAnEAOQZsgjqSOWhLE9hMLYlmYgvjvywD+PNVh+dw1sQQKWONY5QyqGKO4EpqY7hrVZuXTwDt6or+MCu0zoj7LthknbFhlBNb9rsd+9rOf/Z0gXgbwmlgVl/P8RUugAKxKPQfyYuGbc9CuQr/rFw1fLDVfp9QYDy3rZsYO8lKzdwhkgR1VehyF5D26Afmi5bN83XIJfO1LYEEI56gGj6rxXE0O6Icun6XCIr9IASwAsPZvBjQ4tDADGhyhlJFIHp+HVS4D+IsU/fI1a1oJLAW8EdhjdNTqBOpSZbUSgLV1BaugHUckCWhZuGfw+LvYwWoLywBe06ricn6/SAl8FoBX9fgXefYXArBjgCPLAF6dxb58rzWxBL6oneq7flUDBRZlYMG6+eab/8iB/ZGo0TqzVLWXGXhNrILLef5LlsDn7SZalbwuA3hVSmk45/8DpuUksLeVwtUAAAAASUVORK5CYII='
	Local $bString = _WinAPI_Base64Decode($Smoke2)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke5_240x240.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke2

Func _Smoke3($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke3
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= 'rstHJaS6h5wUSwoSL+zFd1KKbQrZkwly3RiSWS5EN2oExKTvqr9OCIT+VcWNac0lCJ6ER11lZX3jlBvn9A4lQAJ5rEDUiwgFs1MgKxFg/N0AcvcWL/cCKYcghbiVUwFTIEiCEDD+LvMiTmlrZ0JLADJ17okrQZQBR4E8XKSnCBQHYCXQFcqZbrRNl4x60+jcWvymEyHPl8oFAVlN0p9H2F/UhH4wfZjixz5sX78GC0s0HM5j79A9Eb/NZKtTBkI1KnvFaFFr467IrOZrzYuyg0H0yCM/G2jGRN1X1pzkLyoBZlv3vhfuP+lKzalXCS2gjuY2QclVAcihE6NegeTLDeVo8RiMfdZ+3MdptfRvUTe70D8hTXVdz4oiB2qZRYvTv+CoQYhCkbmlmYx5+QDyAtAH1ehDoQxUtZZ12ha/3LJZzILtl3f75BVhIJtAoozrUgIcm7ANVcsJu+8AcBfXQECiym3iB6aYOaWLpBbt7NkjL3OPA2nGGmJVWgrFQY/7lXL9m3wd/OVOEgyBoFiktSOgS+MjuAdQFa+Qga4EcMX3zIB7Wu69KjBBiQSk7T1ln1YNc7vEBn9/+kCL/DzBviUaZnoD4a66p595wqUAg9IbZn0bXDp8zBpJrO7+YOb6sQ7QdiW4JsKRti6m6IgfF/6y1B0DnCgBUXN2wyDCQM5XCHH01blhDrYLXpg9wkSWfYZhNBPDK78ut0tMiSEvbMvLN9tmgbmbhAWSW0JCOzRqh6ArzmpArcJAcEAMglIeIQHtEKuC7bPNgsqsPB1pYjnFcT3asTF9XccdDvWTOYAS7NjxnzuC+GT/u/IaKErRgoiGlHvv7cUYkSqIAURG0dTPuQZhFrRXzorUCRTWB8fBTU3OOnXtK+ISMGTDFSnCv+HbUHO7sL2FAqpmnUMTch8XZUyIpijvz6TJQgs9ikzkJOs3Jw0CdNx7AcqJfOiM7PG2Kg5404ghUOug37zJ4JNZc83QQlB1lc300kDXLIWc2/4DlzGa+CVR/QsEPbYG+nre5rDPetITFOIk55QVnAzkI4n1klsGv6KfcilgHCwzfNYOWp0h/a26Xi7OYElV8KnaruSdUjhNGWpKSmbB//GbBCGCM8D2hQfrfxHtPO5TvqGviKNQu0fywNexq69NwWNq5uKpC1wNV91J0RBUuQUlCfNgvqjUbrLewKaPCbDnLZhB6fLmQka80lP/Xjw3VUaavjbI7HehN56fIec1Yghvs4NVob/labeUJ41dtx44HCMrpjCzrAsEfU+vMKxWzGTGgGRqJR/4ITlaJiP6Rot+qNEaBFii/1WnxhjcB5c+fMZsWGk/AbDZ0bzN9ss65iByfsCeol0fi8NmkZasTDObJQOilyM8IR4quAlWLKroaSFE35sqtGol4E8h9Gk9Se/PMKOrV18vIpgvx+dyYlcTkLtHk9e8ZdFo3vJWRli2MNhRcHslIaBEI75EGWvcc88cGJfraGhVFfbghB0FS2YINAHXGioAqHjp85mgbJc7CcXizpiZHO1MM3oirdy2M4kNwU2+qft99ZO+InlaCbmyPY1I78stcdSFd3p580HpbzRmE6xUNqOdXQUzeY8faDyEd99IG53Z7GufKJBsAYVDQeZh5NxdnU2VAGWcxzwn0EaEHifYb+qzqLAOy6oe0/ccKLbge+TFQOgq50fm7WNPynOr/PvSL2jCafpQrRe0U/l0WmpQrYZY7lH841zrx3S/3/usuH3eujc4QnyUIVCYuBCO5+B0Mhn8mwLRAdyfMFx1GTRvs+c1dsWgj34v232weipOxtnvaasEJVlkcnDmvCWjzUA0rsuLhhi3BkqAfy4sWrOQaZ+4aLnhFKnTG5bSrGWArb4D6hHkCdnjtNwUsaLnMKhCMKTgrZtyGaKNfVS9W+6HcTMUQi7Gs2RnbUZ9g9H8pir/qGvyXhXQCCMxiqA+VF80D2wBxCIEmdTuww4ItISxUcxzmZM5o4KY55OywtBQoeFVXgVb'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '/Pze544u9ZAt/J1jgNCiRrcAHFC0eZjTXHVlhzGqzAm1/mLoZ7Xk/81Lh9R+e7s2k7L//6JC0CzPr+ikim708+gvZOnZVQNeQo4FElhfX5U6gBK95UDlmw8VgM0yyc8sI1gpy4NW9T+Kv5FGVcvH+orwR0k0/7lcIcBdgd6ziqiPkN+oJICVeuojBPYMfDfFZtS2GyrQPIu2euyBt6e8M4AL1TLg9zxEZx9yJ2NtDu7xDqEsBaYCj0whi4rsR7bXXQnsqu7aiM9C9o8xDnusOxu4MHTCftbriYfkuXp4s1EkQIELAUr7N09L9rww6aO3nr58VB1UUbb1g19jf5wU1JaxFzp8f3dy68ROC0arWcWnsMM71rzmQtFAfA2jSs3QyZId3twN5EhtKXQqXML97T7DwyVXf2t2BWSKb/RHGL8gD8OA3/iW3H+8E765vd8KJYOg/5tDJt3r0Y8TnnK4jgzWmw7G6fP1qMV9eP3hZ59dTQO/hNpr46vAABdZdk4x/i+Xp2uMfX/ssGkIkVkcPC1t8/q9Tf9ror17gWAUzchGuB6I1BgAhyJF2sRWvyh2oPB3JWCzsARtKchjaqvdSlZpsrszFVI9uCWpKAYmDDsFwLQE2ktuCd4IcXp83sn1+rjzS9oIqWPWgvrs9rDfGwVqF4rKaA6CvrZnuw9R33WKt/PlQdh/suA/XUIf5JSn9EPVBvn44V+vYvq8Gy3bYNtSXJCXomhhWBiulFbahag2yzkmFSsUAVa2VHWJoWTr9lp0H9eycGn4UR6CCCxlIRIdpUC6Pa9MJ6xxDufDasIKfjeLimIaGfpHK58bhKCgGIgAAFp69oP5+NeTYvr1j7V5zoGED547+MGDqhAjz3BQIRATJM5eGGiheO9PhPn/DjiQmr5mKy+Lr1ZeRpFAk1IOTM+fdzvkpQ4utISJEarqB6VG7/6auWyT58y5XRBkH70FAUrDoxx24Qkis8XiTdpf5k3QMmH/vzOTbvuUsysCw7rpQu5OKF6rmehD3FwVJue3KPkotyAUqa9Nm7Op0jX33YXFnwc+RawXsutz09yyYnOC/6Flm6UD7g/sf+MfTv1k3mP8LE5jO4lNk234vazgPNP0KHzzB70rdx+YJFAq3TITK1iP//YEBhB++9z+Z4Z3UgJSRQpHj9/yzszwE2VgwVn+t2Ug3RwBD+F/JxXMsHsqEFG+tQJQwFeZmkH10GZzNfRIwEa35EcfGxaA5OQcN5+EYCVi8CTGikLhdRRgn8rRCgPeGOxpSqmhcQ0uMQRJhuwDz0r/zleRmxujNRxIepgO52LfzdPuxn81MdDfXNCur3C0BqV8q40mwpBMgD7m1jNRFjYZHwziaD5rXf8GNNBYXzsjg9+TZY5/nHHtbCGVa78AehAIgAf+haDeBK3xxzIesIgHtqe0f7tFzRFLlNtbVJx4zaL8YzQ+t9SfRMDxAQrkYnk2wTWtsmGd9mFom1rUgqg8mNdorIqxEeG4frE8QAM6RaPYTh3BsjXylsS5HQP7U76nTPYSSPqExNiXva/24+tvkAPoU+Ltfm5EBtQ3ZQFwmpGnEx8WVMwHs+AwCF6V9tiDOMY36VbClVsK8Ycx3O0E3dET0vlyioMDH2JMLXUFfuzoQPzuHJsbaRN3uGURJr99/kEduFb2lIFPck0hkA3xMo+dDptaMVyLh3XpRgBr5sa0vSAGK9ZP7ec+o3HS1PWWkSU6dvKoldWH/yPh343H4xjBg6+0BZl0ek319Bqmjg3js2xzTeQamZbQrfC/F+2fXwDiUfMsgv/WS+g299uU3vEuJ802W5bAVUT4F3cCCH8NDHQY3hMuqavFFj6fGGy1v7zgos/LvfQRmTUx8mLuCBUkydoZ2nyVxkmcHGGfou0dHM3U/dM1NkutSNuajEMUem7mEhysY3O6a4XLm11dQ2FEQK6tzZSSsVgpDqbtauaDmZzlW5NbAJUainuP4rdTnnDWU3nWFhfmlbUNLcqP2cDR'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= 'Ut2i6pkR/lh8YuO9GPrIRC961aO1uhHv7XVqgip78PMer5vgE4qfv/xUC9/X6hF+rGuYFTaVbU6W5jJ4Onvqt1NfW7URKX4IBmw0uB4rSMAixSIu0IT/2DW2NBJ/rOhBF1AYJdPum3KL09z/fVn8yTTAJnqgu49rId+uju0qkQuDWBhGn+L4Rt7hj+GFykBS5D3v7WuCmMzSoNFMeG77mOt72JNj856K3DwF/TwiCO/uMQ566WenQFSr7tQHOkzS5g5v76NS1yMvsY2SAYselKdYKNMbJAtHt1rsg7x9D4OpFXR0y9a+vodZmbqzbW2Tc8hxYQBr956tRzkcSBP2TP87LdEvJ/SRW+1L6F8ScbcC9WZp3/Rtu3nMyPx5ZQYZrsgm1pnCigKs+9/LoTDl+vQATE1gCu0VX7AC/76nMrGSqyzjWw4Z+tEDXkPTDV8Te5CsgtMX8L04KqOFbyTXswFCNpkCTjGulv7YNhwLQyDxegC3jwDV0KLdXMVA5UDsMNreziIbnk1pQxx8cnsKbJTMLuyLcK/zNircsYkdn9hRKH5asvDe29eksB2xlsEoQX+fbQF8f/NED/hMOznn0h3wowaLx/hyGVEP1EvbkuT6WuvFKGqqtpZmQFH4+Swz1kDJQF4owb/2JSSa+l9eNZKO448jId4PY9FHgIsOP0vJjAaTLwxTNoBzgsAkoKu1bxh8HYeZPao90Zr9+SckxyGEG0VgnIVXZ5VSI4AdJTgpUVBHstDfdUhV0yB18BAhZE2jN3+7ZbzSlzAGVvdHbofcSjBbQFVptNi2XHQ5HEbvGHjl8EwIy717IxIklfJTHENRkvc2RFc87L+8ICxckyJkhUO2390LOxfe01ijEokvgXMmNCwe5pphPczis/cUvCyI5e0dv7/5+8fsv77v8W3b7YaGOs0AAXpdL//gnvbPdX0vMXyzoRdLWbgk78mlQv7W2P11SuBPmf/50QFeX/xj5NNMG7z+zIDE+/un1JVh7Zbjwr+vewZc/eenPa/Xjx6wtl/P/t0+4rfTUOg3BhEKf5wHjAqmr1pTWyQE5o4Ew5LMSFXMmwIZuNLyNiHfzznWuW1N2jkhKhRSKKxJURBO2OYGRmzKP5Q1/vhCMce2aGpXAgg+JmjLKs6+BP62nVZMNYCMlML5VEkVq3NYSKp3VAuxEes28b6uMdyH5KLfouUirRUZomcCJzTIRgR9LPAtt85DDEC1V858yY/ozZZpljOWvB//ua5I6bt/E/Mj/W3BfBYVSEGaDiYDPSMdHtSJCVsREboAC67SmUChGP3CRIUDCL4Jeusr0InSt+X3+C7+G5Rp2fUv6FzamMbgQe3SHJXQ/ZBb+svt1lEqJECOcn2CIkYZp0cVLsnf8HGE4ut3MRGJ/j5QA6YUlNONF9QCdLYb5w0bMGM6uAkgOJ+RCCD4WKh16Naiyy5yxUej79fJOytUDkNDaRlAK8hv5upfgm5u33uRROvf68Rflt/VKUjqIryFWf5oH0PQgnkC4HXdPontOAISJXFBErdbCqY6Ggg9W/j1ml4AlW4kKIC59TVwcSYYEDfFLUoB3xrCIMrGiLkx46/HJUmFdQ88qMR6oBDHxAhe5MShskedgi/ipEoWnJmH4W3B0ke0sVzgnwfUO/pUt+6xqRAwp+o817WNyjQqFqIHAJrwh+llGlvnFwL7D+r8pRG863y9UbSQJ13Zl05ejj3mCTUlwtGUH16a25zTxmFVCHQaur//MuFh6SlUM48kAb/t6OfBf08KgI1kVQCccM4mq0CTrTjBQEdaGSZgVAei+qy1fsZwCuUnIBgbBQD7QicqomQMciPfd0sAP8ChTWWhrElMBIVF+YPCHZUeYzRF8HfDtgujvbuWETArZVFyyZRDkaOf8W4/TAM/PV+dIo/ro1PyQNNLC4Lf1JHaBHQMMV/6kuhM3fh4mmsLeAaVaSN6jF2SCofZ2KMIkEwsa91gvd06djOw7tbdd1EARR8Gp4LC'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= 'Cu/a1yLUXToyKvHb/CrT0l1IQkALhxEFwNIQ5zZt+jAyspIv4I8uOtxrOcn7Wvo3PXapGDOqDJjtWdHJqmUNFMOWSFsyX64ZDon/yc/J8J2pgZbYz75wI8bly4hMLOcJsxpcZLVp7K4zhTwj5boNO++tpL+9OHjJ8ygk87qM9uZEQWEbFsOw5IaKUgAzjDFyqKNtAkW5UTUP041PppUs5pT860P6oIYINyHMZi8pjlONPoXyRPXdpgSrdad18hmWMrOUM0i/OalGr7W17IqFwhAXM8oCaiHP2m99ZoOeX/KdZ0aXv5/MjtNRpgkD7fz3MbxNML9ufYVIuSjsLFivFt30abxizQ4XHnCWQf82oeLdq1BSJdnpWr6f3JCC5Q74/jGp9TtLwj/7dKmJK4fnCsa4rNGFtgu4PZPzG9h9L0Xh56svtvN61jkA1zqR8Ecwe3CALLlbIwku2fZHZuKsdflT2de00s3+uYVnThTgn1kLG9hEa8ueQv8SsKg5DsZSYq5r3fvnR/ZfvDZXKbMWfHEqCzNgcfbEsh8uRUbGc2150LgJo+YaJoDlL8MVIP2yGl9hfCTB7wMg/C0FjKFwdS2wHKI2FNYVBC4F3abpoXbnKHzSlXtBkeevl8ojTdupR857wHlGIFKf2sW1PbB5p/z8rQgP5Yi2NdBe1BfSGlwbZLJFPYYBhPLJy7t0wVsTPTaA1RoQr5iKdxMwesDlkJ2qJrdpbbldZdnOv5/nX0EwbY3MEJ0gqgiADpH5uY6NJOcCgEIlZGdIPQzeeOMWOChvrXUOWhXld/0nkNX7d2L4Ry8fLeWIp4twl2Js+cAVq/BDROhQbZSxiyrKqMSfVZCUmIL5DAdHtm/ocySmseTxunQZcymLP/qej79ZbAujBl4s26oWVVok6NNXMfT3F+jM5cltYhVYPddIB11pGbu0lp/V0W1nyW/aQdANLHy1ewmf4ScIBe9nTlROm6WRWSqLe0yv+xS2r1uS6PzDsrFuQfuSjH8V8RI/ulZ2jdsVKd0yR7fsVlr2/HV9C7Qv3E8j8V7Lu36zZCnVOIRFuku43ffyDqi/nxc8bxrRP+v4Fd1Z9XN/agIkpw2t75dlT4JSrBbyci7o4USidLwGHI084xiub/qaKQS/Je5A4Nmfx/9IHqKZH+H+Jv9Og+w5GPtwD0NBw1Si7nFX7iogicpiHj1WHoKKulgWPz4VeEp1Bdj0q0X6HB8SJipTVCPlVHlJxkry8h+2M+2wXdcp356W3muY0bHR+Z18uJFO/UFVmhWQRFRipFe8iY78QENVJt/WC4sFyM4KK9PGJPZNaUCgeWRmA2/P7DdgH+irdtJH3gu9vM2ux5EejIeqSZTANIoD6FcS7mF3ABIOBHTcIAi/BAEIkgrjUn0/frq/tiNt+/cjphW+S9+E8KekBwxvB9YLfaL4l/Z7T377Zzrij7kcUEI25cf99ol+ad7SSKTFB9vuAqRB7QsKcadt0xOzLADAocH7y++m2UEpzG0p95Hf6aBQV25NO5z6giQBhaUEtkZ5NArN9W+DJchv722hiNQHVSwpwWXMzYgcbgZAH12Iw7oSzkKNn3eUyRPr5B4XCA0JWvv6kYDfr5UEZ/rwOfLlxDpY5wIoLOO7ctR/P0/meK2SFDq/FR/XCpbFtBLr6MlCZAOpvlHV7Nnd8veydjUuRaW/rtnFSC8VjuTzYL58GT1+nr9e8zBDYjXSeSX2MU/uSmooBxTc4tZyobvcAQYN38L56Y5T3IpCtv6Yz55BYgpeAmnZu7nS7WrjmAsMPKps5Uk7foJXKJkuCPvH9bx7nhwVNUAgIROWqqHpM6yWo9GQhcKBgz7xjo3i53dhpfB+NyAN6j/aywPd3nE1javzNQ1auOsrVXGxuClbbZ25PYZtTyOU5SPUjbWL9vYB4OiXt0TVn2B4JUD+l+btmyzXQaT2yhD49t1J0GQ0wMR+4mahDIxhmk/Spin9swm1Y5s767WLfW0+z4sC'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '9Yk+4gqDdNN9u/PUgksCIkCc0JL2eriRqi4/hXxd43KrX/p+X5aHQtu34g4MVqAL/A566kFxw2ga5Jg30E9kKDh++RmXucHDyvAE05wQbDAfbFjAWAgMM1uxtobi88Z0dHEEw9QJ/8rVPhf+W5u2e4lS0pybueOj8pH5cFQ5ZThdRHJX8qV6n/EBhmmLO/qixzq2iShyvVLdRQAlswJ7pf/Ws0HUttlZ45PiWIECVfv9Tx74zrAmfIIWvk0eMRLA/69m1eWb+XAyAQpgVhr47sIHoFuGEFmA91rTLcpOeml9M1t1+NLvLv+kjF+pfgxHLAIcSJo3WqvHoaW2jQl5iN8TfPi316er1RkjftNJxsJ0fs0NkOYFwkarZLfIQkeViSQW9cvWMMxF6w/VOhvkyCBYf3+LZ8i4AADrj0TnwinRjnehV/tH8JH3Zcqpiy9AZuFHQHFFjbgdW79IfQZ6frpVMDwJl1sItgVO831F9jzsr8r3CMo3HWT1SA4iIrORGKmkXRG3gOo4hPTdQhTqipeh1SyFw1JBkeYR0PQIw1wIqx10kSXqd71ocIL2DWyyVM2uf+n4ZCYzAkE5WNjdat14Q4OMOX0LqmTjvPv8YXZv87UB45y7Z3mRam/Ag3/lOkjz2+Sh9zea2MmGIAvZJASCrcFn9+szVEu2MoZHEl6RI6rSP917IVcW6MrgZpABBngXuUCGN2a1JwuXX9GbKPW5fE8xzCBH7YOYAFlYhwIQECtVt4AXY9873mIla9ki9FEB8KOEDXKNUISiIFl7CfpTggCythsd/LUCEEEOzVDUMcJ56Z+U2irsfKqz3qvDWxLIbN3627VJf10CFHVAurs6639lK63PyVoILlLKFLSZyXijKgApAuiB/mkq7Dne8ErqQBgQ/gxPkOPuK3N/bLv/jKwE+ef1g1ZVwC+1A7Fd0h95Ou9RUyiLEJ4Wk2QCFga30veGTKAVJKhVijR6Scdew/dek7JG1kj+l8peARP0EGHZroWtDQ9CGAcuxHGgQbDbqLEpMzLmMyvZ3JmgWyNMwQAl2jYB2JnLq51jnRh3WzyE7SDQIi07Y54wFAUW1/M2z7b1nQc8uZPwe8vthwpAsi6bScX4tPCsmOLJ7svldVP+AQd4vI7+FPa2Or+P+zLHdu4OdWs8iD6+TCasqe8OAvZlDzFqqUSOn8m66T8MVWRJtwHCYdTrp8tetQhD4Ey7wMcf0U1/fO98ZQXAGI8JZjAjYQ7sWpUpMGiVD7dyjY8Ot+QHFB6aDqVvrCpa0f/zr3GBAuC8GVEA11SAHDBaiFvt2qv1Gdvwnn5jIP1BP0LtrYFRqPzQFf2Z/mxjULejtV8mI0PGnD6oYxRo70noM0yRtuY3C5/6Xx/b1wX3YxvBwsLyPPDMI8ujb+Hbi4J8vlPv2x+U6+g7tbsZCuTaukuSTwFcBzg2NdqQ3amwHSGw+tL728xxItJ0QfIGMCxhLOzyCis4SQ+7eU1w3XfJiSbvWwX9ECBZHH6aoR2UA3EAl6YTtuy8RHKUsIdZMzEsNWe/bJwHOmw0kwOiSDO9DQlSXM/8/KVQeTS2cd1kGwrp9Cxj0cYOh9Hs1INAiXH3rvbLdk6qsKeii9l32xor/Gq/kAON7XuP6dgg626OJpX3UPzT1Wjbj29/wG7fMgzK69gboLdAM/SvCGSeIUYkpwDKqdi+ogPl5khqlXgoPTSXJL33jz5Jr9L6pJbaJFtiEhMQn7teLcsPiQaEbyZWCMgw4RMj9rA8YJLzr0v2VKAlj0qAuABA6LtsNF3Sy/ZvFfK/1n+tUgHaUhkIWPxZayP8MS+aMs8/vgoH8vK22b0hBKAm5sZTM6/ejWfwPBeKwPnKGMOpPzkFaa2U4e8PCMHnRx/pqOmdN1EhWQWz2Sj/OFXNQt4ENMUY8WgyBoZy699eMZ4nJQC06Thw6aQ0Hax3oP2mMXQv5VbUQxoKDATwL1vue3t0W/J0UxHg3EGWM35IXeawrdD3'
	$Smoke3 &= 'zMf4szdldX2m+7liCWtc4JKQL7IIPdsRYN8LUzejARP8pH3ftojINnMqU4ndHs4p3OC59OdLwhXk2x8L7YoEkIJokDY/TnVchxtraNllfg9tyPdFOkXI0QAlp80zz9q4SsjSCifRwfea3k+kPgl/e+XxAB4wSo6FuPo7YJlVjrtPc/6IdwQY/PFV0YRkaDUS2c/fZP8JUHWStUquTBvoTTqNTDEmGvCPiLzkItjaoPr0z+cHBYD8pfeaXhDs0dg73cuPe5YYPyThHJYQ+OntBoFQHw7M25TxlL8RGzBgbaKK5b+H7/8iix1wXcMtflBGquIaSEEv/MO+AxA+z6G345AHnR6/6RZoZy06k3qoT3kk57JoHIrrn6ZbmJx04G3v2WfzUj87MJvqk9waVJnZqfzuHUQoqqK1dT/IQubup9NwBGUW7QsOT9sq6unctjlQ7EryIy2xnBrcJzdjpLYAMkWBbxceYTl5jMFq0+VKxMu7LH9riv0VdGeb8tGDV6nu+XvXLdtACCDGDRzWaOXBWMPOQF5QgVlhlv5XRjrMO0czTdCCYRHKuJniSLi10VB1hoDMCfy/RsCYO+CxhHnrAZiXFniNC5gmqbGUmqfUMuuolYSk9EP6wKQotj2Vx/hOmX91olYH0Vl53S4AST66ugZ9+u37q/JySsJ/bwDBqqE06/E0YXMLmNPJ4wf0uoobB3/JCkDRubQJFo1wIIgZvp/0/+3jKruK8FfKJWGfBHCx9kMgV5cAWPNwjfITMFMaFOn/wQoDxcSWUGpz1UeNJRThD7bi7h/8nISgeexy9mjxolKylQe9aLaI1bnyUVtbTPFxVhRn+GHO6NWznHOLslDKX1fo+6GVTw+NJ5sQAdpRKsGiw5HpFs2hW2u7cSaaQUGQjrFdkTIUovBaWvHOTTtlJu0DoqaUQSmWILhLdgKRvJjE3LR+Xyvn//r/MpeCBPTzICrSB8MJJVjQJLX+wqwnFHq1lo74BqWqbmV04T9AZQcwEgOkLuA94ppQ+vh4gt/IshApGnAr6uC+YD8hMNM2AgGNflr0Ldsc2dwTAMKJ7N9LASZHb+Y2BqlYEQf5TlBLu5idAaYPTIoDeljkJBhRHF2vDW8hsv4x3P1YeXh31c7ZzzRG2hNCgQWon0edfJHoUu9oagoL1GFY4fMFfZ9RwhBwOFq7ZaCLhnIZfMaq2aVJPwKvaxSGx4s/f9mYWJg7cR9YQ7LQtYHe1eh2HgTH+ffR8Q/xQSscYwZbhhGbf3F+sq/2vn9Z4anV9uvOuU0TYdsb1W3dbcc/RdW39iBtP/yuKryPwhqEDg0QpMZpwYSr/stza5t7KaaAD1zqFxeOR5N4RO5zyCqyE+kGWZS556zHdtk803sV0jS0nzZh/UBl3BrpQg3KDh7TjxnMyRPdA+LH7vumOzU24um1BLClvHdX9frptv2kt20KsN3+LFn8jR26wFfeRYo6uNYhvVg7LcgOBo7EPhe0fbkDeDlPSXPsUCAmMnAvJYMc39ypeDpvVem49Az2pYpY0J0lNfr+0XWum77G3NKoMLDuYLxpsGVFXmEDP0295RwD023IRnJqEbOu2/jl7Z3SzRrDdhmg5FX2xNzp/3kGfbZM+PQ7ru+AwH11OLrq+TRG7CcOd5pbxWPsa+JtY/6Nq7Xi6ytd9Is2eM2ttdeP3f3HPr66fdXCNklmo6Z+FJkWxyaT7f2V16wqD76Rka3bAOFPNvrTSzCrwZf9WyKdH4cFBHWFQR/P8I9/M0whAAs+IEH01etv2VWQFQAoL5ebEIXSeo8FcFXFrWXXPFzHC8jhM9JlpMPHaoeYPxkXwDCyTp1mwgMU/auhLd+itWCurLeTg2BOFprlhZWjij9QBT7w7Ve6Mcwv/O+Mpuz3cwvZFUFT9NYW9REc7RpVANtsYp8T/mzHn1Cas7916qjH3pH9BsguBQOudMVAs4Tsh7EB+8udaSWdT9uHSZQslYL3w0PbgFl6SsB563KP2qU8'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '+ogn2lmFzUeh7IdX9IpY21qDoMcq5Zvc0t0HOry7KhJ1ESte9bXaNClg1tFgzqA83IxHBxIfUYUhM1EJrq2nz4E8eJN0SUSFhPTk6UWAmgMGTokEWTcCqKf2hfQNNtLITemHGY9z11VCfFn5kl4amovtq24Wu8/ns6sbd9y+IRBH34NH+65Nffzasrmvvi3vzch/9b18VLz8b31AYty0ccjf0WX50bcGkLsyHQMMWRCadsT4gWVvHe4RwjgbneJzf1SWVglNwajBUT/6OwKTvQroXbQ/mK15zmzQ2Z9O4r8n/LXg2yaozby5z38YCMBxoCqK78eulGrhAPeKkTZiJkSNyIeBxd/DbIMpr8L4EjyTpGpLwyo18Oe8oyJenaHi+hKDRoPZVpA6Oyk/c1IrZaOYx9LyMatXHK+xeostNPathwvIHNjkEFgRdcsNs/KSC6BCDrDte5fHTPc3QQlSZbNOLJLS1IzI3LCwLp4egwwD+LKuyELvFyJXwhtWmoKksTZb9o64LJzOuTacDFzvl1Pa2gUi6vSUIHgX1VWQvuejGr3sMyA0jOtF4h6tz0cMnUMt8GchiAfodXvvbyP1dAsJZlCaHd5mJ17sVy+GeAwDaoKRSRVi2PM4eqygm7YaNLyh92th9rdAv4IKLc6goY/ehHgEt9rpb/fmPz1QWwzKvc4M/tYP7jX959ehR182cJVz3hLiGA06JMadBzNaRGBrHrznqxogdoIQAajjcKfMfGhjJrsmJoC3dAeFCXTkxjRN7m2PBl+bB+Km0ApaaK39aCz/tQv1KHQBmMtcYpKH66kBG+gz7ezBJYftKw9Aitrb/to5Ng27No/q5ZYWXX2zlZx+rlmRAw8fbW1tjD6Vt0te3+9a/ZMv3+iB6DrYnA2YC8GcDQVQgsTHHCY62N4MoN4aWTwQoSdNPoOpUYaiNmN0WO2PggXHW/FfS1ZyRAptrE2p83zTUWBY1VVzloG2WRp1M4NIQmJdDdgIps6pTWv4cxlBh8bcqwj+zMiQv4v9+SSK3bjje08Ijea3OodPeHuSBU+MNOqys8hc6VXb0ggHGbIMsMJvhVlsM4GizbnqRj+Lp4DHR4weNRjClIKDckwYS/9KKIBzA/Etfe6190MpuMv/ZwhoE/+3wL/8+OeIzD9uA88O6Bv8wqC6LgC+dGgF38L/n76Mu/3fqeevYUifvvZRm4XtnLAxnFv7DTQEC7wDo/vU4aV4s9MTksEQGdMKRmMMibZ1xTaqwufjmIebm5nl52FXoz/L4fifu0iZonlVGM303gghhzXOzeTIWNd/d8XYBPDepwIXnd0uhjuG1fMcJ1R+aJYDHEmh8vGjwA4CU/pYKC2sQAqsqqi8GQOzIJMqgxIBVf5jJg8BqQO0UXznBUnL354vDXxZeggG5Ov1w0lz309oiC5g9PEl7d1fSPRKWAGrXCKD0hJ/DbXXlagiTc6Xgpvsyafj+uXlY2dArTMiuXzL3+thWhF/gXR+V4FEyG6JyjRu9kp4y5MLXxGcYeVM8Eda9b8afrlvxJTiUQGEKLZogVjVvSb3GMJzBfus1OZWqI/6e5/7w+6i6J/jVtRWk+TJd1oB44VjCNuO0SvsvTEYN/Q3jHWRmG+CDb8+LgvvV89XvmQEfKqtLdLbFXA22/kvxhwMGR4QdCAVorXqiAvVpeoPHm8xHNNfg/YLtdMs2znA2OpfDZbf9tL9iesHLIZomSyQyTDuI9wiWmJtmiMrhwdvjdMlmp3rcOd49BUq0QenM9nr6vvLfIZ40+XaWsyYAs6cYr/eWf9LIkt7RfmswEuEiJZDZ6LDbKHFktWhhQnzAaW83P0SjDC0+g3VczUsijPdFk4zWFxjw1OozWm3rKmdT1Q1C2LSCRrzmYaM7UUzAet6vEKoSJ3ZQwPmfs7W3YfXyvOZPSuTK+Hun2U8hZa/JYRcC34e4IxbW1aw7POth3znRKag+PhbTJuh1KTcx1hJamBUzn958KmP0+2A'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '42bDcjb928njfacUCM00Y/tsG4rvNVDMLgjCgDdUbE8cMSLyQUqxJkcpLGJe244rXUwpFQNKg4QCVjyTQzzfYjWMeFWYvjMgxv/Xj2FADdXSN3dimk9XdFYEBhJNWSNVdN2gZqgN4gCwbgI8wNZzZgQQxwbsxIhjdOgxUiqkzRs4hmb2ZH5oUEKby5nxUWbppbeMpL9EvNtlq2coDZABei7q/3Ri3/Ew4utVruveETAggYCy+qCWK4rz8iV5LAkBAOkPGuejg03KXqSp4vHZ2OpfWDiWPRitG6J9HjhYMSu8V2fIAsTr33Bea340vWMRvwJswM7szm01CA7Tl7MJNEEdvRuG2xgshWEuWCfXz9xvIGCRQWdzL+dsOY224tV436q9EJ5uMe0HwY+uRP9JyJHWI10nw6dJGSqoOjVYyxsGaROH9RP+Vi8jHcNqLhppy6poosxAqIRLwc+Wq6jh79vpc1pWDddrLdGNIWPBo6kNd64FVmNIRZj2pZhzP3n0530i2kCCcHmeKduFciNYR5sQGKkvWN5KCarsh4SzfSGdk4IvaQg68JLp3ceOLey6Ex2JLvf9I9qBxREv2iixmShZccfxZeN64AYWyO/jVFFi3Bs1LcpNHHlZuYr5VHRdoVeyyft3ro8yxfX47mRPVcYpcELEroihYNdrJ8zlfsJfDBxzpKC2dWVwKwjXNtIV/SqFhleDcpqRoAfswPwPHcW43YMlX5raVvr6XVn+wPuQOZaj6/es/tJaCHJjEPCa99pkSVU5NjbHV9Z9ihrPEzneY6s6NQv2PNIWTsQHGes7CXj5mHGwtWQhia8v2HXQ/pqGQL6R84KdXczqQ5MKx6O/r+krWOvT5cdbG+nmhBkZIEZ5W89oyTIdk5a3pBfYZjP2JqFAIFAzW1Jp9pLVuSe0jW8YXzNRLzqecgqPznuYkNupr8ufBe/UZ71Jw5YZZ9yPcmLjYHfVma0jYrrKXNcIJkt9ApsWElmSK2mQe2tQ5H5jhR7W0cuCqUGP3McGRAFWteH6gzryeBo6k5q88DacCkBTqarNVnbqZaKPwn3nWXNwjcetpHCZcC+4edug99O84kDFnvWiCVvz/qfGxUcW/seZS/2dUIARyGpgzT1C2r0XgB6Bp11o4rXpz2j0aTtt9hF1uwM6XGAbSC0YTqZV1X6cRnYsJ+eBPGdtwe/pmrWluZ5mCT+SuUYDpju6GSVphe22BSSe6A1h5mKTGoEbyjUm+8SmlY09bdvqw8thfrldvuiIcpSUKwl4+S5vkuKG3ErpWVBQku0Vd0r3yKTdEPs2LY6bNOWTnLONBvako/SWF/Q4TXlga65E2ai+a9I4IUcsEJ+iNwUStbzy/n59XuIoiAToZkr6M4gVMYkj9178KsGvYZjYJHVmhFhFb9IZBZg8cKUOKqcW/DLNhYqX2TgBR1Rt46ZRUgjozN9WoOZY2EVkVS7nluxgQEzD9oAVKoenGUtV4DDdbvEPm/86ergzEc2BBxmvRI2rHGjwW8beB+XIRP6D+4fYnzLAhUCgc59X1z4lI3s7/r19vC3+372qPXMM2L/G0cn2zN2Gcxwp0p/146/O2yWgLhS1L605e2fBxpvyy+yCxGCm383yStWkZ30uF7NyMroLRSF1ChkkewTg7SWcI2/bCRY31289oLDe2iYPWGqHu31NQUcOtGlbydEkM6tRlqKlPwnt0NBr0Df7NF9qzPqc5P2FmWWdqX5hEmQKPB6jhHd+xtzkbKokSjUTPqehXrXFofz9yTTp+eeNzpI5BfxL8hMbaeu9Azxtnk83CzkxAJT27K8UZ/XtXX0bxjDGeRhJbj5q7taNd0a+/2FWsqYucyMozdQGNSisQ/GxPvUpWdnF0/KG8IsrepXKpAl4T+/LsSUEfq47KqJuebexiAgGuMt/HMnitJHtHFBXzXQ5ZmGp6zJg2oMFA5WJoELWAkx+pOHP/b34tbrqyo9DGx7f/i9cVzWPPrGO47hjhu4t'
	$Smoke3 &= '/0WafYpNnbsjAF32eJjWx4dtR9L7oHUFIEnjQTVHcpDOK4ohwybzzyoGQ67VzMTz3yoBvVUtBvH+/V1ZuergF8dnlYWJsBfDYq87tfFBKQ+SlmBI0uu98jl/Nx1ag/TEGuKubSRhlmEAuKZ4uTX2pnWTeZyZ6WrZYE2retQ9riaJqR8BZ48VLxB+nb4t5ZiHRRXIjfcL7IneAH9pNkOS6/6BzyWhF6/kQEwn/RrjmVd/OKZISnFS3ocAlLyDnvzTesC9ScgeJQbr3lqEp7lAsUBSVIAAsY4Zo0bQuUFFC/f4HM3lF2M9WfQzdpTAg6H2Z5981sIkEAEnGfRnxY9Ggr4lMYKtd+Ih7mEk7CZCTxYK8oRorebcCPwVTJb3B4igAFK8hgYAsQK7q49RCj6GOTu/b+RLPORPyv53esgHFxq7sHzPjLqrLIv2t90BdRxjPXaEsBOWEG89s9p59mHxq6yDqdZZsFfVtUpV91uMPuMSS7p9sm5yxxAJK0jL32Q1uVFdrsmRkrOPPKpE252mPCpFwowj9vf3FwbJSF7vcC0PNkzKAWs0K5oDesDoiKryaTxG2Qm4iZrSN7WflcLzjuGmrio7pUiDN0JQmKCaVgNQtikuIHYA/GC2m2VEIdRrrC1nvpXYk7KizdsVw0XqfBUi5GU6wGbGHDT2WIB06DKQOC3Pu/+ANCZQsN+0GFN6RhrN511Ulv4fuuap8fuoVqarmCs2BxhK3dVjOf+h/u5cX3vBdxk0mCvSAwLG7VsQYlKCA2XY0y+nQ7sxuQB8WaErBouKNNiLYbw8LYxb9+JD/7Q/MJZeZfBTBJs2UkLFiefENx2H8B+7Ppo0OvQ+MbKN7bJGFudwD52+D4CpX9hjFUsoZcl6WZcCgx83aHBkOIte5odS51/3was+qXKETTDsRwiBBTAliaVtaEFiDpASK6d2qTsF6kXODw102K1oazVhwStH78V35b8UO+Bf0/v5+f1X9cEPpol56xntkH1mDqcEpE5/Xt/dXoDapgVSPGUN/OL/WvN7KaZ0LqLB9ORAqGlzi2tWn9kiVggKtNPvsCsZnbHF9JLrgfNdnOSDWrZyxdp3MFKQNcVQHJIyBMcCm+2SmULSZKjvCvKtp0nuj3x//V6rsgXFHxR3fyA4f2W633osFwSmXP8cNjaTsl2uUMD7EPPgXMfClKl9UhIvcaoXaFuiOv6C8TqycrZT8qUNVuNT1miS6FMZEb+rxP2Z60n440ZAuGkPvk+6dzwfDOba1q8rzAawfX8ep8gJq7JlxLbJrRvcvw4krmWrlj3+DVRgthEGvJVILpCZa4DSPhxMSLzSsK4zQ/Aw3Z/RChtS7pCaFJaPKozxTg1o6flsBJPim+kBC+ppjV6ltaNi4QG36gKl5SVjqBDEd1DinvoutIVIj0KLqlC0cNen0V2vZrXsH0qVZmJ8D/kovzeNF7eTU8WFp4vzbO64+IF1ulELmqBxv//RVkYj/3HrtI3CTSjk1oy/ezpIAzmtFleA6bjPHAOzhY7Wdt9sxwRkR17mJXGDTQECwMsOqbAP+Qgqdqwo/vTSWKS10jnhmVB/MHpSWd3o6qP6jgcK7kpYaszCP2IFox7uSuB1Rcu9RlC93SK003hEPjCl/IDM89ugOLkiZI38KMD4TysIv+Na2Fn7Iw7AG2HLii4c/7wH9b0/dBsGq79+BFUGAiC31S9ynDLWELRa5GQPFlpwMNiI8wUHaxxPjCYDDTvgVdue+Gz9/2S+VL0/yVhBRkP7YA/tBYSgE8NBLBQeaKlFC4r6C4Eva6GIE2k9kGflyKxw1wC8zhitq40/HfUgBMR3CZupSm1400sL6Abf/8lMyuTJtnuS7A6RMBWHfdFijJZDE093a4gYYH3QTkstQjCnKMBEP+74YjXMWi0PtWTW93x4fI2NI2BwT4pysjnb2OkvZgkiCwJjJQyTYkxTfIPaCobOF7RpGu41L+/9E4iaG97EUoxWBV1/e4zdeTOS'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= 'NR8e0PY3Y/ycfQr5g7/QCBEUsEFrotgGZBJy4ieL6v2sHc9j53vamQT8zdIiW3GkUl5jo/GbYEheQNP0K0mbvaZZVB/GKtLSHPp7OP2JNFnbEhA1EPMS4SJy7PPX8i4MOweja4t6Z2X+8IA4a0adr1Gdd6ZK7AY3azJ6+ZgZWFHOfTaPRgDkjDvP8MBmK6VxHEQtWOQSiH/QH5LgxG3B+Tt43fpPSHaWLimiFNOpcXEsUllLxCgZjQHOzo2yjb007b997tnaVkIlpNmwubuXgEEO6mU6HOCo5KvlK7Sd8FFlhS+1nZE6a6FxIChOPPCx9QkUKhKxWYUOmE8ffUgzDJLOBskHlItVZ5upCTQ9DBoyg1zHUFC+m1HYlzXCh5N3SlG+FLmPQp6cQURvPvB0L928B696h5H8vKQQMP7OfEEXdQSFhZWz75/rh7uOazXNANVByb8/ZTQ8Twd7rkpsblBbrJL2RogqqFosS4K4sr6LwmBPjPPrVO5LSeAKslkAe+tL00zSRFLT1KoMqohxUL8FlZXYF+xwGqPDcLQ71qqh44MEgAtpaLzwlLK8ESiQrhYGXBGgs5dol0aVBNhyQohCvXKo44WDN0P73qXdz+BRwQJAQQL2rYd43CtkVTjw/eMgom3b6PRApDJb2764X1eB7WpXQa/irMztub5oM4RsJD1nFYvw8AyvCrwFCvRXtbZptcwZ03eaf5iHrznGDP2vSchbKx951MTe032KZhj21XqFPkyWoYo8wOf7SixrsHmluYT598+1jBh2QKlIAIh3GADof3ndP3p9Op+uOWg/RyRWT3gRkb7kJTpFaVC/8LJgPoDJFWO6F5CfuQngLNUCgaWzK8MG1ps6KDtr95Am+KVWQoYmnnOKIyM1KMjGLMwpq/y2F2yFDHk+nrTKbFJ6nUXB8wzAEAPUFOhtzqRMN83eRCWm6H6g947XrfWAh98eEo+uzIk1+wYJHwcOUVPNSaYab7Bw4KDa3G4+2KiRB3neK0nE7PV3EPdD72337voKtmDBs/B7WtiYBMHLbrkX26mT97R7hAn8b5kO6qKmQW3SsIIEJvVGSwiqGQY6A61UToOOal0YlyH1gBdL5mGo1uCCQwR0HY3BCm0aXhGESjAnWLrH7ISZ8J2MhI0eiRis5KqvGXF1n/4xycCk4xmgfRYDwuVEZ+0jKk67i3tPVq1gjW368kWA1rp4bmyujMuhewvCtWvQ5lcAlaWKyvnUk53hvGhvRNDcEPBCuSR8XKN/7XRAuknMXwWwCRHOvkef9R6t9satQnkMAWBHfb5u903peyIBC3JJp2ECWrbE650sm6KNIkHsrT3cijqDoBzM+/G1NRdBaLs8jgOAWk1bOwyw1tFeFg5DS1PM+SNwWF4ZgN0+AYT5tTHRDa2C0ldFFqPA+lB8aCe1Pd9Cng/JqRHkP50Q3u8ANTsDxjFj+76HuE0WiPtFpjV/2X3JAw5Fb7dn/gvOWFooUxp+XylrT7w2k80/faX0dsqAMj1E42gQd5VFxq596q+voIv5YJrt7S9/RXrSEW9V0l6sRitQ6kJ2/N4yNBPLFaUd3NbTwL9fMpldPiWBQJF1WGf78mJNXZvm3b6HIyoe7EAdLTqEERLdNxYC6KEIEarMjLRRTAVwS0X0noySnjyE4jKVLtx3OAiof361Rb3qBArlqEHeQodIMfjJInUwZdYUKXpj9RYU+lJ0wLpBDyjKHzSmxc/2gPELmwSwIQG05dDhtLRtlMGfGq54OwQILRAqNIH6DeINUVStxbytbR7ZMARYLAPuaceTz64PBIg5YfnMEogD5uDHUZxgJNeK57ojUX2o2QQ3rTCAXuhoBTlmU8ZfTZ/T9gdOwnzPCn+MAqidHoLeEHJmwxt7Yc0JyhHVCvF++8Slc2W4vqzOiQyG+E0unRc0lsi6KABEdfM7d6ICCLAhmkkO0OV7X/7lHrdnOfHpwYWMfN4uSeoZMtC9QEpCo8PoSasUJueMsunL'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '7fRH+dNuh/NlqGe7V5i/rxOyfhoS/CabzsTWF7OZLMWLeu7Ah4DQJ4/GXDlU2MckG+Yt/doHsFDQrDqL/VrMD4vXh6GAlzr2BNuj98n7OJEg4Kt/lsMahhAw8yWIMWc6g+59bsTAV6QXWhrW6xwJIKXNsU3gYL1dxLBFIDt+Zdl8vgCbC1oA5HaeBQSgRyj7NinAdw6bh58RAEoxcH318I8ph8zrFbvFhC/ycskvm9sanxKYt1o8tNuHdwxs2yQzpixMAGHcYq4Loshh54omDmbBz/Tab3o2xcbm9NyJ3nkP3P12OWAe7ffqZtTOsBHVp+/5dlR/TjU0ze/Vm2n2YVrbBnhllR4Ry2tw0J4NgGX+5oz357oTljNCwJomPzgSBa6U+tb0jb3qBTtYyzypE/qKrZFZmSfMAmR3iggi31R9PiCHJFZ9aFHuqNqBIuBXN/AKPttOtCABug1BH8wglQmg357XLRdRzIC+96FpGryVH1n5kj5O3Ihjj35Q/0d5lYbQ+xmO0xzsWC7+my4mfv+0qXWyNoYO6cIg2m926QmxsRKsDeZG3FV/Ychyg5vLQuMbJlfWxM1xAODEVZ2hrm811oiUggVzIbublLlMtKbNXxUARncnp1BNB3m6xC3pmWbPIDdD08HFdnGWqWXcdIu60Cbe7nxQhVmMbEtYGkagIUqzNwElxOggUBBr/6or2tygu4nhVjw5z54Yc0RSYxIYO94N70eko5LhM4AVmD5bqb8v/QoAlK4qMyv+JWFzENej8+QVDv0IlnSOfu6FsxH4XbF1TBiT8VCekWLabRjnIeFLXVoSAJwqciJNkD1NBHGs7gkYjcPfV6CpEQjUdxUFRlAH7+ohlqmhNAPh1Fp5OdZfoEtv2oVCVxjwBGF/W4KFK+YuQfiUV5uddEZttCGtlHb+d86Dye7Hll2rr6hQLRyuZvwTdHX6ACTDxI2FPTgCmBwnlRkhaicVoPRug2CY6kfM3InAS5De2mxKBYlFDf+Xqd+UJltH9FzUgJdS9qBfF4NrkzV51q1B1kEy0Uo6xSZbO/k9eutCCYNfcfapAJC9s3d2utlic5//AH6xihhY5yqaZE4cAnWso1bnJupPJFciBNqbKujBZ3f9aZJ9U0o3p39U/0dIH7rPtAyhieCuCR0g2PJWU+9qF8opIJaFrhKDEIy262nNP49hX1CXi/b7z1CAsyl1+QuW0mXXbLcH4cn099jz3+mIfMWl7ugb92+gwUL8XbVpFn61yM9xgijbxZGMoAPhKX5pyMCArLYVBn59PLXk+jbAF02tjeDObt/XgOn7rgEx/sAWS8ujRAgc19c12kFQbTdYZvEZpU/ZPXAOcjpR5Lm2n0UvFvJFAm3GnfW5BJQ2l11roZnzUmc4cJJnMDV1YY02WJkDgfl5bxbI3fkwuwf6VMY5jSMHQy1gdLReeFhosZekyJwJ+RFi8P3vS3eZIK8y+XeN0ZrC6uU39+KJMncSd96PMdd7+VkAhp9mNhqQzyujDY/PUG+6CQJkgIaFrSsGBRCl8JoA0PXWV0FIyN+PTr5zhBB+HV4bmeUwm29FC6J9K0YQAKcOqQhG6KtWcQ+QGG4P+SMzT3cinz4PQ3Xbud7pHzBYMkwlw7UM7XdMb/r7zgz3978Mz6YzO9Zfv7YM7e5xiVWjTcZBviV9xLyMIIUTvTwvAJwZ9bRz9b7d8pebAdIqlGiVS/r1CizUF/c9jC8P6SCfmh3vFQCe6+o7e6ravLHd1Tkx5EaCRCpMkjUVtn0Gqj5tSFDCaPz8j+1/4u1vIPZknx3b/70JXwkXrt9kKlOCLp2VkC6/QG8W2usjSmpgI8nO/cBxvvKvaPh3pJvWlgVbTGaKu9QOnGD+N68PWfoW6TS3eqTXRunFCMBid7YSH3Q8MEM8S/drr8E4BPD9kPmdgsBHyKsvS0tQWEmmlXIQwFkNw1WtGaMCwxVoFb94BIkYHcCjOHuAqp+6p1EAFCFD8mM3F7323w9B'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= 'BG21BDFw6EtAn7NXD9GvQGwC8Og2IwMjjgt9z2NNhZwHgzzg/qV1FAtK6MsQUbCnkeoBIJpqhfliwMdGkLyKA9CGCuuwtxIAEvotwM+2lVkQhojG0JsNzCOZujrGw1pLQ/q4ft0tONjE5qM2iP6QTetY2899YFrSu4N+MilAzLgJ6BcW3L0z1HSfS5lHZXSQ0HkV19LTlfwy+ln6FQB+UJppub12ofNZbtLftsF/9P2tZdBH/PURCBVz0KsNa95ZUB1ojSuUPlheRwtNxBzR34G8fJZNa225hqx2M6hDnHwdulfZ81MPqslysdY9r6M4gKO/nJUfqp6ODiFiA4MCC2nN8z87rdILThe97W3dvvZC4TKMM2XRz1l3Qv6Ger1+PkixvErRdgFtIpDOgGttPQ1Z93ktpe/As3wXnrr9m06kXwHgg9NMy3M5zc/0ZDil8BuBAIlB1Z38etVDVWcEY4LhCprrKwRB5e+61AIWGWRBVFij8sS8rsc0Vn3ZhMZNQ3fIgx4OZAM3H1YuwrS9bG92vq3Rk6/T8ula5ENRBuu61jD1+Ce7MzWKbcYBgzZ0OrHPD0ZlfS579C2UK8wfNeYT90EcAvz7R3NDP1W0bpIBvANAkFvf3Y6/Tkd0fsi/jPXfS78CwAenkXbaZ4Z5HlVPD4urvW8Y+PMricD7sDOTLEVxNdpRIHnjvjWeS7sJ0PGekaIC8fVzNLa7GmDM8uquyFIHqukSmV0iZKKDj5O8s5SaeSJYfpUS0JswAgoY+N9rtt0zyx78yE0/EAwgKxcVAfmrMqitj7o1bUZoe28c84+UW944Izp7MphEpeaJlr0VA6X6qpaeJLh88zXpVxB5X/oVAL47PQF3xdD3et1hhXphHyxOaZv6vuKmyp0gWNj2rVC92moEDN/AYBE8Q7NS7DZDOSmhb/vM3vQY6uAv7NxnF/qxpjp0w3uaKUDPvEv8zLqSTmpa2bK5Sq5IKjO28UDA6MaBXQaDsnh5IzL7dFD7QDDVQrIvwH1zwX99tfPHuXIs1yxdWCCuNvfL1T8y/QoAH5zW7HuxLXAKxSYrGS+AB8OmvQAuw+xlZkizZyB+YZPf/XIm0DX0/ca8GzO6pWSBWJ+7M4Wb9gYUxe7Li/o1Ik4xZLcXFSLgBb9MeEiRfxhfz/JGv2F8s4p4QYyFAQmG9wDyOZ7WRbE4fNemBW8HAe5Jv0z+x6VfAeBNaXlRMYbV/j4k19BdhMEKmbNanzLddo4MxBl66aEbZVeJXepGNXATRW3NH/bn4r0nE/TMShBuTJjti1MkAMyDMIZf+zyDisLHDcX6Iri85vJpYkHCPO1MxEH50RClhXk/zuzwWRzab/pNp9KvAPCKdMOLGNlWo7V0tIxkmvCK5izfV1btxcqNlJJzQY5BoLIJpKoEhSxCwSsXwpN1w+AiuIc532l/e/eW61gEfU7VnSIDyY15G9/NARNjziK68Jt+07vTrwDwQ9MqU79SLw5qe9UCRmbRUmL3q6HWf0PbLxlvAEtHqMSVNnw9oZ36BfS4o96pX74z+EN/6S1pZnoTAfWsli5C7FrJ60/kV+D4TaP0KwAM0qe+PBNU9TXjCTQaGGa60GBnwuhHuWK40Pdue4YnVNwotNHdsH4Ih/+ANOKXkUDzPsa/jnRdpvcpw/1FM9tNo/9Jc+o3XU+/AsAb0/mX6ue9hquMF2YX7+RsP4+Mw6FEw0nh8x+UMoTk45zduLf5z5UiN7T6m37TU+lXAPjGdMXWekcb1zLCctbQjHAFDUAYaoz/Yhoy/99k09V5c9ZpxmfRCNkpL9TnJvrva/KbftM/l+597c9o7u9fcM4B+6/t3w2W9j4QwHrpmR39O9JSf17c6VVniJH9XdVhmfjqvHubYe43/aan0v8BwJ248PibSCsAAAAASUVORK5CYII='
	Local $bString = _WinAPI_Base64Decode($Smoke3)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke6_512x512.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke3

Func _Smoke4($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke4
	$Smoke4 &= 'iVBORw0KGgoAAAANSUhEUgAAAXkAAAFJCAYAAAB+eV2QAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAzjpJREFUeNrsvQ1z3EayrN3AkCLltX323rj//w++Efc9u/6UyAHu1Kiy9XSiMJR37bMSCUTQpsjhfALZ1VlZmdO6ru04juM4juMtHBe8m+N/9u+Gn03x/TRN+tn1m8u/l2/1Nc/Hx34cx3EcbwnnAeblzwDw/P83exwgfxzHcRxvFuyjQk9QnwpQn14D0E8HXXMcx3EcbwrdP1M2UwHgVYUfi8E3C5R3x0d+HMdxHG/pAL++JujvUjc7C8E3dRx0zXEcx3G8ddBXVT+1LUWzWnV/gPxxHMdxHMc3Wt2vbUvRHJX8cRzHcRzHa8P8V/Vijsbr2zzAQ/bt6bfcXDqO4ziOo5I/jm218s1vRY/jOI7j9nGoa95wMb/zfVXtf1oVjkr/OI7j26vmDrrmjSK8AXjb0Qff2AWsB/Afx3EclfxxfP2LvHt1aBGYDfR1uxX/biwSDsA/juM4Kvnj+Moq+aIBmz8eQN4BfP30owHwj8r+OI7jKzyOxusbXuBzkZ8J6AH6+reqfPx82qniOUxyHMdxHAfIH8fXUMzz/wDxdqPC97//Izz+cRzHcfwHjoOT/xI0/AR407foKR3P3SkUVuvBxUdF7iAPAO+vGROArfh/3vU64bbHcRzHcVTyX/8h7rkAwm/i6e+8poWvScBvIQobFz5SOH6b4ziO4zhA/luu5md8fTNA/8LuY2JlLwDXzqUlZ1+9F7aADIqbo4o/juM4QP5bA/jpNVWuAmH+X1/Vy6/+XVA7x/TscRzHV3gcnPwXVPDtkz58MVD7ttNipijS1zbP8zle47IsXPTXajGw6r21Qz55HMdxgPxrwHkCmHHSr6KivxzLBeyvPE0bJZITbrtg0dO/4/fLUcUfx3EcIP/N4+FrrlbzNSnrkuA+b286VZTV4WB5HMdxgPy3jIHfnnTyT3qta7XQtZGyeRVhx8dxHK/2oj5sDW4fr133vaOjn/31YxVYvqUFED2V9a18/hxke0MFynEclfy/vhC+5kq1Ai8Hcku3bzuV/re4eNOmYbUdCz/3yXox/TZfI4jiMz0quOM4QP5L8KAdniwdCFH5fyvN1rUA9Zdus2fDzL+fv+DcOCrp4zhA/tsodl//hfoHaIlvZmdTaPlX7EoawNr/hoNdzSr62e+zfaaDfGfAxzsA/zgOkP9KEf7VXJh7QH6ryoV0tDm4fyM8Nad49TrmagFoW6qG7037wsVtUCZBarpW/Y/jOI4D5I/jT69qd5qtAqiy4szhqenGZOxXtYClTUNj9Q3rhgmv90voOPrnb3h8VPsN1TsLhPWvAvrDEO44DpA/Dq9W937XKYb9Tc3UvlKAJ6D35igN5QTwdOBs23CUteg3lE1Wu92Sf9uK+15stuAP9TLM8nmvFzJVg2vHcRwHyL+xYv4GQE6wUz7vUDZfZaUogKd1ssCRr2tZlhmLQbNgFO5WhteM+71+j6qdgD+Ad1brAwBbVf/vLM7ry2/JUd0fxwHyb6+M37/gNxz0nwEOTlmwwuX9E5CsKXoFxqJRyr/rzdSiYh+A/ALyJ3PbbPaa47FO8c95npfz+XwnX5/4XXxvi0D34tffkM7SY8bPL1/PeD3Tnsc/QX3H23/wFsrnthqd1NrR5D2OA+SPowCQlxaDP7qoLLf+XT0eFoQOUgJGB0QA+AmhJzN/78Cf1fwG6OPnBOnLcY6f6XeXn826TTyffM7x8zPsp9m3WBLslzby8Xp+w2vnjsMbwzufx6YxrPeJ2QdHNX8cB8gfB9Uf89dEyXi1q4peQJkg3CkZVOoO8Pp30230fwLsBcA7JXU6na5VezhzildPyicqc1XS66Xa16Iwq8TPin/J77lbIp/edxtaGLAIsVrnYrfR++tv83Zz3nY+qvjjOED+OKpqevkrKr9btglFlT5o'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '21rYctBDU33dgU9VuwA9bi/ds77iAhHYk4+H7GzKAJGNpXBecFMOgyxcBBjdJxCvqn5wxovfJgFk4m7FJJTcAntjtbR23QP2PRD2BVTviTUAV6NfKHFcnWbQDsZ85ku/dapSLBaOw0K04j0bl3/9e6QsfSQ9wwCO+BJIK6hDoHn5m2EVo+Io7aUXvJYlH/M5z60mMzxZaJBm4sIoGWlW32eEgzT0dTT4dLq1E1SzGjnH1/sLs75Q28TrzAbtDJmo9490ni98v7CzPbfRoGzRRK12IlxwTEt/APwB8mUVScBvO83XwRSL2/FqvDyr9tWrq9Q+q2F3PZlNWSHAOe9JIMk5cygE06CrgfhUuUfueHRXtA2lhqvTGa3IIt2jWHb49XLX4MEhDjpcwL6kJ+ALEmwTFlvsN7sHSjeTYlpk6avFXffPil5TrZRMcjHhwpHnzhMpC4KuB6JokWMh0ca5ihMowhMkpx1kxaML/DnBnOfcWi3YFBXIhbWlS+Xl64kqM32OUKZV6iT31hkUb9rZ2rm07tBwB9AfIN9eGtRR5d4wit1yOjCq9GisnS4V/JCEo+o+t9BnBBp7nF/jVCKzYm00/MpfgqedPJzjFrgW4D40XPdSlHZ2O21vEbz1+wrgC5583eHJGRM3eM3c6B1MhVeLT05OFU1TvG7uChb2UlRRX84BB3lJKFdy9dCkNyRKTU5PyTI4z6Nepfs8AXYqasg+UdLrA1PuwQRZYsuFpXEC17NsuaMEbTJ8LqCQTv5574gJhsxiV0NZQ33hQsBFrfjZcRwg39YbXK1O4nOejEoUWiSPS3B/yi3znUbD0471mQ20qpGqZChxqZ+uxVG5A2pm9uxVcsVFwtPsA1b29zcbom457GHIbVSa+MBT6eteSBjXvYYt6Rm/D895rRaRQkNf8u9o0K5OQe3tTGAZ0JusBj6DcyYWcQ9Knyows76PdgB3lqM68zHNzfSUBnl3rrF3ag7ulqtLRbHgBMWjKD8FiNwD+OfUzEsS2mMnpQzCezMMjhVUadVEXUiTgt7hwuEDUYdvzQHyI59sk3MrK5k8OYcGUQL5R/DnZ3GzAKEmkzIMhLAKUkBDc290VvUEZ2u0zn6BcKCqUNJwm904dbvTtFx3EngGILThJo6vt2ZTvQVV0wrL32qhWK03MFT75kuzVoNSrJThj3OLRuIOhe+bdnTSl29CpwtwlX79Htmnk84laetJ+Qk08XgLXUXjvvP38ZyetJhkL+gB596041nEmMZN8xKvSw1hOWty99cnZGVvDKpyQTHDaeB7e/ylaJo2nEMDwCOTdgGdp/OMfkMH0B8gX3J3E8HHtO0z+fX5E2dz9ZLXRfn4+Pib/kbVDitrAgGB3wZPJovnczOwimNm1cMQkSoXc73VEL3x3lS8eTXgtL7g+b0aQO9VcJtwi1YofPKzWndyW70CdwdK18YvO06Tw4JCBQjTvtRozEpdTc2uwlK2bzZUnwm6sWvkzAU19ODq42+X2Dmy0mYTNX728PCw5nDenEHu93pu4tw5bEQ//ATIc2F3oMQmcuENt5uZF4s+xGI72TN6DKvZgKy241oKSmexvsBSLNIHZXOA/OZEqLaLG65UVT2lkjqRLxfVx6RfJikYeEFY49SDjltBr1A7fUvyuItubqPri8ULssPBu4bVehvla62QxZUa+ULXvgfIe1z9JsQbU46L7UJ6Y9J8XZrzv/aeLDtpWG4bPFSgnFYl8IMv76EtblIG6+Azq2DbGUmBNBiYOZDqZ9EuCtELeXnuEBgq0rZmen1HoTmKLFxOaFavrqnne67rw3sDei+klOFOxRbPsw+b7Zm08Tpr4xzHenD0RyW/13DdNNzkmIcKY2bzLS4qSsJ4ogen6sHZrMSMJ5050GQ8+urVVBET13YcLQdtvVfalfwSzbeNVzvN3GwBaMXvN6lBVkm3thOP2GqlxNRupET5QsNGd0HnkLYrG9lmPdwKOqaR0qPu3HzXJxiyfZRL'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '4KeKCslg7kdZDcfFHoAOp8Lr33348OHKyyvEWyqLrLTOOWE5+OPo8dGInV1W+QLAc+dBGwNSAo3NzRs8/7oH+O5F0wpfEG6H2zb9ad1bLDiOL9dMBzZ7fi4drLxqzu5Nw9ATqW/i/1GlX45rNR3+6emh/sTKN20oeoxj3I8WcXs+9MY526DTAmO0RQtLPLbthHx6mLx3l0kSyP0z3JNXEgRv8dFmtzFzeMwya4fP2oC9ih0sF30AvPdbhiZ8G0PkN03UncJkzwv/APm3xMsbV9pPTm2nBdypmHkgjRO/jws31DU///zzj7EQpGHZfQVqWcHdpZWBK20qeuRWBe9KB2a7OnDfut+p7cTR7fyMLojLlyQDufc6q0bYJVdyt81wlYFYA6hvegfUhEs+mJrxZ02uajAqq/iPHmrdUu4aRTdnI7zpCSpppbqFHLxNkZ45UXrLA4hWFEUPYJOOxcnVVruV3tqx9RBwKwqmHa577z5XTJIPk9Psc6GBvxSZxUMKFxeLKvv3pQq/eIKvwlv+APnigyVVYr7vK9Ke5FVzJ2MyjcDH7yWfjN8rzDuAXmqZjAA8pdZeXOzJvWmch9yr4vd+dsNbpBpqGm4jmeiX0i07NND0gknZrkNl5QWjnsWt2QBY+rLBqvs4sULEHMMiB1BNFysGMFU0k4d5izrBtCmtiWfYWJzh1aJs1GdR8AIrBMYsiBs8wW/+vDNBujJk2weavE/hvjTwk1mqqt3OsZn9pnhe0PKTt1+L58wqfpAKE8hF0QDYJ89QqBZ53lfInv9dT/rXUtkfIF9zdvOOyqHTNAJyghEtedO64G+q8iMIJMO971Why1pYGbBs5PqQkwVqz83cBvcuzJ2KmzzmVAVw3ALlG+9dS7BoxbRldaFvIgfVaKVW2f9WFAwAdi5kj82pALcspp0Bb4Om6TP48n5+yN5XfHbSNbOrdgo/Hw0obagsLUL8PLFgnNrWVrntcMncFU1s9NquqvPYPmlrlhW7TctmObFOA2GamefqEJNYUG43G6fFDnXdoVhfLf1ygPy/ULnvjcqbJ0cz0B34bgzJPKuCD8MyOUyiImmq4sN/Pu5KEXgYfupWxX7eU1apCocAfQOYN/LD9kmz7KHSVVTb7sXkj4chnKWwQ25OO9lznmybvRl0cWsFt2Gg6ZceH4Zy3brXwYSDUKJnYmcWQ22Pj4+/ym0UGnepdO4v//7dG5HoozQCogHsRmfuFsGW8DUUI2bL3NwSwbX0XDgx79EHpbyPU3DarpBa9+gjk6PSjbKnkpnZnrT0k1lQeEZwFX4z7VGXrzWc+wD5f3NLZmA+VFcKc85tdJ92zNCI60maSps7VehUA8CqeMJWvOTfXeFSVXvt9oQim5XuUjizuro1dNQ+K3OmnUasAL83OqsK2QdgfBfgAeAcCttzCJTypmgAD+Zp+T48sykJ//ezvpJ7f0qV1HMGgjzR0IwRgJ632z7LAE+pkJnQnxj8YFJ9MvnOIxcASSCvqsmUbNKTnlYUmx6F72o8o0B2yjmJPcT06XyoZhBuqa58F4Xrq59HXKzYkHUXUS5QBXC3PYC3sJU3D/AHyO9w2GbrO+iWBdLi1jWWrpNUaVGXr7+J0lEWrKgb+cZLC08feVTokz2nqtm1C5pGizQHkUJKSdnj6hdc+zyYdEt5s2eS1RuxvB8f7DHqYvbmaEX9KLOVv1NerjcW0Yzd+KbH54iBqbM5NZ5V2Uul4zst83i/vk4BWg52sbIf5Jk7/ZKZu4yqt7IzbVo1nxdTzYgCWopMgE305Qs+/g7mFSC7KmbYue1JglXRFw1Vtwde3fvoAPgD5HcBXsZg2m4nQL+jh3zbRsp1vXyAe8gl07rgXoZTUdnzZ/KLx+LhHOVUbeMd5Pc83iuwJ03DShccfwna1Va9SoN64cJyXp0VuGePDjugalFoY2ZsQ4XbOAUKL5lWNeqwi1hVtauiV6xfSCfj//IlckCvAIz9GaMA2878wDCrIFkt'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= 'I0UNXP09bnbxqLeA0YLtUxBl5rNBNnpO+/3jx48zS/Fwftq04Wld5wwHYfVP76NquEvZuI5VmaSOqz1GEgd6PAO9DfBM5ny0ZrCLNOi9QpNEAwO9LwK20NbkdSr09S9ZsAe7aHI/BIT2KCE2KW5yolUzDIJZpFg6unbMI7ibYKV3rJzFEq0epy6uV2YL/JyqV+NDYRs0Q2YY1TDNhWope/vDigVmQZBWYuBuVKX0KpXd9ZhQJpcs0JsG/lK+zSrwyObfcpA3eIWNqu+Gbwh1uJ57lP0XXnVk2iUYBhOaW9swk2Af6MlsbAw1vIj1S+KYZiPK+qin0wITGDwnsT7YXC0wGqFut99wGqoRLCHIhmqcLbA3eQb4oZ4smy+ld9eaBpnXZgrtVZcCvGABa+huFUDpTS6KBw9Oz1K/n4bUOi+CzhgM2//bYqYFNaCZD5yjCLnhsxhSbR9i5IC50s1CsJJSxg8u/4OL7NlQ1jqANirfP4XUMox9AMmsNvU7wuMF461UOg0ocXUO+xUdGw1avaS6JkuolL0m/rNQzyGL8HaDPMWrdpmNYcFD5o1nirjYTxLvgg5Llw2bT2lx3FMNRg046eZlAMZU6WPAJ5u0QMNpQwXyXoE/AvxvEh8DdXJFEOpucpTpC/sNUVsvYYm3hmrjP8LOcAvoCnoazzeK4wnsIrJ/6rXG2aBEX1yudzDtSlnhbGCH3qSVw1vRU3iUMFnGatLiIHxeVQvF4jyIMXPmrIP1bbbjFG1Tj48g76qONZniXjMIixIG+p41IE3iujLAX7ME9M+JkE0L2K1/H/tbrIJkRbAmbLj6DLOmZgyp5wL30Wi9gSDvln+ldxna6bW34RF2/U2xcGLwvqhpPQVlleNPP3+UZj0xezaPxLfWl14HuuGUoD0RTlKQ1wIBb9lJAf4pyD5K80aLjmV6NNAuCCKLnSudo21SNo738vjPnz+vTYzs6fsnaZjQp5YUOWjWtKzeqZTExvl5+OdYmIEnWO9qGkHM6ItlkDMC3gJRr0nQjaSSKZucqELKD+BEfwFozi+UXlbPgxPAHKYzfH4nAQ3or6ghGpn+mZ+Zs5HcAjGT98WA3knvSYmGBfSsp5VKGUC6YfOWdUaNzV3UuN4ouUDXsGmwUC9JNXFs7xWuYWYHDvcJF/PZ3etHN4suYDBJzrzhIQ0squKsQK1gzcyeei2Z/naU7A+kF7abQguTjgEiV9V4yxcySVub6DaVyTC3kXpNJhK3183cFhU1V2M/ldOeJSiFzOBhlrIJZIGNMwF6ISRD4bGteUo8HzTKIZeaLlTM4Ii7k9PPKWT6sAK6edD/JOWgl4r3tHCQTYtuMIa2Y29VWJv8tODeDWZpC1bTHSsCh3aosooEwW33pB8zJTTX+oUtu13njy6vHdfCtjBnHgB2/yxcTK5k0d7IXS2z5/8XLvzlkCs4grxBN9QZP2FicqMcooy92ozBhb8aM8XL5AXY6obtyppPwZuNWmd3NN48MsiZDA5m2+oRwNyEzVWKf5GbPdNBqg1ORbBziGvFtO+l0YoBoIvHq3BYSufaIFg3sAOtli3Al6/+pAwkl78BWqGBdMnYFOTzm93gDgdWNi3TFwrGtb+3BrSmetWXkLGHjg+ZuhKGCcNms5hNEB4rAwydVQT32w2hcZHW3zT0JvkIwJWTmYCskrwwyKtmLlJ4jET+6jVpgGRSdc0w+QRGXbNFLmmiu8b+sb33IE/qmAlEyZB6wqDRxfCj3dxNkwUaMjVpTF4u9IaV638NOnnafuUwE71W9bzQe9mgoBjlF/1tJsSD7G0xhcJtEYn3cMLwk5pdizDe1ggEXLBCYXJGOb1SQlnZf8vcG2/+3//+938FjfM+3u8H+Olqulcj/CV+7voflCQAHl4swFdrnnY3s8kZ+EK+OE8e53mRTk00uRtf/kNk15t2e2PVzF94qJdz23oQbaBJkAboqBNhtaevB2XUcV62wSlm3aRUsqlJNypNiTaVTLxv'
	$Smoke4 &= '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'
	$Smoke4 &= 'l8ns0mjDIJbJK1X4GXQyDsDnu6lfKGmeHCqEgXf1CopBlZWHD6ARJnUywA/Orkd2gPUI9O8sk3c8PQJV5xgjCQFKEPiFicDqPqqz3WDVKGfF8NtsVLujTJIZYVDTapOyW5VhhtsKjsq2i6iPDWJo/2+ZqpqtmmptOuhh59f1IZoMA/n6pjp5cYeCzEOXxcdg08kMRoozZ64N2jC4Q942lXrmQi6RMCw+wp45p3A5jwHRPEJqYv373//+S8A5ZzGxKNkrfnybwfCJYkJ+oNzOpCSCv17ZR3F/0tAqOqHZvzHGUFHxnG+VBZ3GdHzxHlc3Gtd5kkpnskiOqqWrWfSPhk6c9eZSJEfIfodwjVnoLY6NtylTKgPywnHTBGZdJkvQ0fvcmNubXbxYvXTFIuKUyGryA2KyFF+I2EBTAA5++OZq1Bqtv/zyy3+0YN8CPRUZS09xdOYHG7zdwJPpmlfI/J7YMM3gmsTsO4NxeF69ybqbdC39+PwaMswa+e8qCi1c7VoITf2Ti5ahadvx76/0B1ZnArncsxr2/Nx9sTAf1AVw00qjEDf9pq4PrznMbAyNOr5Dxtflf/8UjZms8X5s7xSTT+hm23Se67qUgU6GZQpTcgNl+KMvNNccbLomGCcYrRSdRosWYJsu+Kop257fMvcmPPY///M//6UpWpcitudPhLrKV+bSHVg95Maz8TsxoGaY+wiHf65UJ4sm6I2bxK6fExptgJ0zC6bRuQmlzQ/t6ymb/xXZ9iQnrYRzvjVWSWkVTNa0h+Bm5RpJqk7YJ2B1VrBY1Rh64nSv68t0nraJWFk3o1H6GZJlUMlydsMX3AwbX/9s6OSYdn3HQd6bgMDCCzP4JBAXb5aVfrJ0J8hUBi5Vnm24XEIymNJR3wqMGgDdZPDP3QinJ71SNMkm0xCCWmfAMFJKvLyeGog6ruCNP3IBoX6NNX47GKkMPFiz77YQTknQqIRn8NUpIco2LzRcdN6kR6P3yMWxhkNW0+j5rH1IqVLTq65giYyflNZWwcycjUg++86nFdl6J4uMhXWjsw7gEzfK9muOVN1l0FjdTZomHrlLSRyhnkuUflbBfoTqI5NfjQ1Chkvn9n6NFWMX/eqa59liMshurlYAiWwBvWxp2Lwmr+30TI7/rxDdWoPqNzOwPS0AxWErwBYaDqowPuk405AcvoumbSn7YZdUfMynOJE5SrO/Y49IGAyBnobna+L5WzLGjUMcXAjpW0uOvEFCrnSZLl6QsrhmqrGgv7F5FahpHcd7NqeloTTvtWsszsc8uI531MxkwGy1Y/irsuoDrjky+b7Mfy6AM/C/wJRgGTSmnHHTDY284EboXHACtD5ZVZFhsD5CfkcpYuqdZ41pwjURaE40yIjH31kztAhiIH2TcBMXVJ9+FeSgY7dmYKevYxOumdrkTspXGvv6m6Adc2oiDr75ubbFKhrWu8U0yaA7micw9ROollsTnc9ntSR6ZEJTnWLIrGLR47U3KWhDgprH0k068xoq1+cOlmzeY1T1/hWtt1GFeMA47yvI7zK7n3yx1STwfotr/M75Bz6oBbLCI0GonfRssYZo0Ai3xSc403KtmkLf/BJM4D61wSDQWynMzjn0pMCLadmTZ9AuT1wGHHgskMUnSBEgF2aieExJPG6dwqoFdaXrlena15GtnZvRcCoYCxzhlIXH7CJoLuUgWQ5y0J1dhADvkh6LXSeZR+riNoGjAP7aGp5XejjH9l6CvGdrz03GPedAMxBKyuCZa/ZpLy1Bd+W4dMypY5O9ljDp9jdw3CWQdbZslMHqDkNfnXNRdlMBFmO2e3loNAu34B0slw4vRmXgN+6K4JVq/SRTmOkovhmUdANciVdACY35xySYtGM5IwtfHJvHItiqnhmvNyOb7iQY3IijhBgaoSwf4mKlEz938wOJy5ZrMaXQDqGjQRVcB/fMa6nYu6ro2N5HJv/iAP7CjCHF2K+V9aPS8hoMZG49G3c8svgOdglYZbMm'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= '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'
	$Smoke4 &= 'YBmlML7FA7Tok9yf6a0oWK8wC0kxRMfM45iWYNSspg/fHSMWj/b6Z+4f1Mo10YtxbJwqj111YtIOndKjMWLWRJrAdd3LCySADymCtwd9rn/h62bDoc8ejzWdXy1c81yGvw5WriPrGfPmU0Emk6xdiuHq4fO64ZmQ/V0TCEKfx+IuS/Fd5iaF3q02ZMXnTtYA3fDsKw3QLAAvSdbOJmtNVB+3yV2cn5IMP5XB93WQmR3b+w3ePyp5ezE+r2vy7pY+uHeIXa7ZYkcXHIMHFCwny+6dlnkqGBE38+3izVYuKC4P7M+lByweJ2ljeZ9OYOpQ573j0GuRuMJ0SSUA0GjleVoynRn622ohzIaWrmXqNzh1fQuQzXMU7b8sqQVEPZRUvwbZ+HZ3Cx/acenuAm6XodsE8Bbos/HuuHjmDauI/9uCMMSwEaTV7KQMMoMmufUzZBVa4FaD1jXEt6En2vElE6hrMoxUAM+sCbyyDmSDV4eHEhhmGMSPpumrRQccBqmv9fgsqSpXqsRdpn+R5T4+8rd9vXIEvwwazpodMFw+63Gs5me5huSBst4J2ezl/xIsswtrCV0aPWdG5q7M/gLP3N/fL5k4mcsmWJN3MTriOlCJXMpAVsGC/myBvtrUbCl7K8CD1nh7EM6r1K1JpnhHsFOqEHAE+du6MEe4Y6fXwWGiBPrpBoFMYGx34VPzhZDN03aO4E3ql9QnT1K6VDYPuqPkE07uCuUWgFfkfhdKKVNh0LLuahn/NowFeCZbNJdiXgVHsL+ZKvg1H2OW0A1pobpmjyB/GxfmtUC/MwI3+GUqe8BvYlOSWX5iQ5hR/6aAadh45YKyBclQs1y+KBd/ZeOoIUtNeU6FuoRA0njtdMATZ6aK6qZkmjMD/vyOMnoE+Ju5n55Lnl5DUnfVBCmj6NYkOTu213oVGge2jEeyrz1fQX7y7Ps7j2nXADI7v0mLinB6Bn/qxEg+QcYhfkxcLNg8lZYNg3jm0FSS6dNsgMluGndsuinBu+Oe6uUkbvHzPDL5t4TP9MMc63eUmzvMHto2acBPeN++sEylnzTlwNNiC8HGaLFmrBaC1eCZyZUY+Tc0W2fANwWLwE4crfRTuLv3N6CGZlaSB+/99rL424wbRyb/JjOPa3DM+sJ9ZH650x+EjLpj5FBTAt2snvUjm69i6NhiVBL9+h0Ukw1IWQAvL4BhRvIZR/Z+ZPJHkD+2vwS2+a5ZgUHAf07srQyye11TzpN3Klinne6LAmAdl/zt5Hglr+DZ+oBpk1UlGYd9qHZ6BPfbT5oOuObYXg1sQ6jlj5ScGcc7WfizPsAIIsoyIk7ilvJ1IGv1/wWcM2viFY3XnZRARPl0AtVZP9+gAHk0VG84U/+GJOYI8sf2KoL9+jPG5i2Qjm6MUWbfTRAm2jllYHpBfL/44FTpOeyd0BSwdy4Giytv0moPr/lNzetje5uxvuzFDV/iMncE+WN7PfH+Z12sA9VEDkvttHJMtbKUvXDXqGHZCYM5vXFQgaTTqBxqKiY+RgVPr46O7abvj5F88GulTR5B/th2mcqffoEq2Bq2mWVQzO6zDD6DhyZ5qhYMaSE732Hw5YqnZxbQj6z93dwf/v1VT7n+0Hv0aLwe2w+9m3Jj5OGwVjauPYCgntMXYWbu9EavNI6s/Xaut/rMtTYSI9slSLe64B9B/tj+jBvvuTKaz+sWgIGb01YZAOv3gaU0mz8C/M0mFcUrxmeuu91jbjXIH3DNsf2U5KFc4ZkPfq+UXCj76dJ0n6aJ7/tcD5nfd3e9lXKd7rvL4G/+5ByZ/LH9iVlWeaakfsnNPLqJR1DNsb3+qi9LBl4EoSTDgeU7rqubvm6OIH9sr+Emz4J3HWT93zzhe2yvIog/t9D732vyuT97PfyRhOJWr6XpuAyP7ZWV2lnJfa0UP7bX//n67zX5f2pbeeUaeA57ry/Yz7vYDkz+2P7aCHB9EvUI6DeQzCe/j+iLo+nUUp6ftC5XnvNctXDT'
	$Smoke4 &= '19uRyR/bsR3bn5XJ1ysVXNZY96nUkXhcHVQN1xaedzPxemDyx3Zsx/ZjU/dnlFKzx3DG4ZpUxzNsqfrM/+KlvxICnJF1i7j8kckf27Ed20+L9yWHRmrpMXNn1oyotmsZN2I9w38Oiql/oBJ4U9uByR/bsR3bT0MKyhhLv+pwNsjCd8/n4N0LvABcgG59ZiE4MvljO7ZjO7YuSn6bKmp9pgrI9j8NFpKacO7XJPvPsPjUkObI5I/t2I7t2J6J+YPsnaJ0GZRTBv9joB+JjmULxKjJWuE5cLPbkckf27Ed24/M4kcc+JJk074grOU6tTGjWzJij5qyo4XkXbBOjkz+2I7t2H7U5myaazIDU7IQjDjwIz34+kKIxS0y35XsxZHJH9uxHdsPS+b53fD5ayJi7taUidpdWzhKUimUkrNs6nv7UI5M/tiO7dj+eHRPhMISn99SxpRKsl+WK4tIe+yS7VNNWXMh80nadxfk/78AAwADRnzZPIkhkgAAAABJRU5ErkJggg=='
	Local $bString = _WinAPI_Base64Decode($Smoke4)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke7_377x329.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke4

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode